-- MySQL dump 10.19  Distrib 10.3.37-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: smartfar_retail
-- ------------------------------------------------------
-- Server version	10.3.37-MariaDB-cll-lve

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `sma_addresses`
--

DROP TABLE IF EXISTS `sma_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_addresses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `line1` varchar(50) NOT NULL,
  `line2` varchar(50) DEFAULT NULL,
  `city` varchar(25) NOT NULL,
  `postal_code` varchar(20) DEFAULT NULL,
  `state` varchar(25) NOT NULL,
  `country` varchar(50) NOT NULL,
  `phone` varchar(50) DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_addresses`
--

LOCK TABLES `sma_addresses` WRITE;
/*!40000 ALTER TABLE `sma_addresses` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_addresses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_adjustment_items`
--

DROP TABLE IF EXISTS `sma_adjustment_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_adjustment_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adjustment_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `option_id` int(11) DEFAULT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `serial_no` varchar(255) DEFAULT NULL,
  `type` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `adjustment_id` (`adjustment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_adjustment_items`
--

LOCK TABLES `sma_adjustment_items` WRITE;
/*!40000 ALTER TABLE `sma_adjustment_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_adjustment_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_adjustments`
--

DROP TABLE IF EXISTS `sma_adjustments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_adjustments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `reference_no` varchar(55) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `note` text DEFAULT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `count_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_adjustments`
--

LOCK TABLES `sma_adjustments` WRITE;
/*!40000 ALTER TABLE `sma_adjustments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_adjustments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_attachments`
--

DROP TABLE IF EXISTS `sma_attachments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `subject_id` int(11) NOT NULL,
  `subject_type` varchar(55) NOT NULL,
  `file_name` varchar(100) NOT NULL,
  `orig_name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_attachments`
--

LOCK TABLES `sma_attachments` WRITE;
/*!40000 ALTER TABLE `sma_attachments` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_attachments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_brands`
--

DROP TABLE IF EXISTS `sma_brands`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_brands` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(20) DEFAULT NULL,
  `name` varchar(50) NOT NULL,
  `image` varchar(50) DEFAULT NULL,
  `slug` varchar(55) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_brands`
--

LOCK TABLES `sma_brands` WRITE;
/*!40000 ALTER TABLE `sma_brands` DISABLE KEYS */;
INSERT INTO `sma_brands` VALUES (1,'R1','ROLEX',NULL,'rolex','Rolex Luxury watches'),(2,'P','Patek Phillipe',NULL,'patek-phillipe','adf');
/*!40000 ALTER TABLE `sma_brands` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_calendar`
--

DROP TABLE IF EXISTS `sma_calendar`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_calendar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(55) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `start` datetime NOT NULL,
  `end` datetime DEFAULT NULL,
  `color` varchar(7) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_calendar`
--

LOCK TABLES `sma_calendar` WRITE;
/*!40000 ALTER TABLE `sma_calendar` DISABLE KEYS */;
INSERT INTO `sma_calendar` VALUES (1,'Mustafa Meeting','Meeting with client Mr Mohammed ','2022-04-22 00:00:00','2022-04-23 00:00:00','#3a87ad',1);
/*!40000 ALTER TABLE `sma_calendar` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_captcha`
--

DROP TABLE IF EXISTS `sma_captcha`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_captcha` (
  `captcha_id` bigint(13) unsigned NOT NULL AUTO_INCREMENT,
  `captcha_time` int(10) unsigned NOT NULL,
  `ip_address` varchar(16) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL DEFAULT '0',
  `word` varchar(20) CHARACTER SET latin1 COLLATE latin1_swedish_ci NOT NULL,
  PRIMARY KEY (`captcha_id`),
  KEY `word` (`word`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_captcha`
--

LOCK TABLES `sma_captcha` WRITE;
/*!40000 ALTER TABLE `sma_captcha` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_captcha` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_categories`
--

DROP TABLE IF EXISTS `sma_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(55) NOT NULL,
  `name` varchar(55) NOT NULL,
  `image` varchar(55) DEFAULT NULL,
  `parent_id` int(11) DEFAULT NULL,
  `slug` varchar(55) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_categories`
--

LOCK TABLES `sma_categories` WRITE;
/*!40000 ALTER TABLE `sma_categories` DISABLE KEYS */;
INSERT INTO `sma_categories` VALUES (1,'C1','Category 1',NULL,NULL,NULL,NULL),(2,'C2','SanDisk',NULL,0,'sandisk','phone'),(3,'C3','Mili','0',NULL,'0','0'),(4,'C4','ANKER','0',NULL,'0','0');
/*!40000 ALTER TABLE `sma_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_combo_items`
--

DROP TABLE IF EXISTS `sma_combo_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_combo_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `item_code` varchar(20) NOT NULL,
  `quantity` decimal(12,4) NOT NULL,
  `unit_price` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_combo_items`
--

LOCK TABLES `sma_combo_items` WRITE;
/*!40000 ALTER TABLE `sma_combo_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_combo_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_companies`
--

DROP TABLE IF EXISTS `sma_companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(10) unsigned DEFAULT NULL,
  `group_name` varchar(20) NOT NULL,
  `customer_group_id` int(11) DEFAULT NULL,
  `customer_group_name` varchar(100) DEFAULT NULL,
  `name` varchar(55) NOT NULL,
  `company` varchar(255) NOT NULL,
  `vat_no` varchar(100) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `city` varchar(55) DEFAULT NULL,
  `state` varchar(55) DEFAULT NULL,
  `postal_code` varchar(8) DEFAULT NULL,
  `country` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `cf1` varchar(100) DEFAULT NULL,
  `cf2` varchar(100) DEFAULT NULL,
  `cf3` varchar(100) DEFAULT NULL,
  `cf4` varchar(100) DEFAULT NULL,
  `cf5` varchar(100) DEFAULT NULL,
  `cf6` varchar(100) DEFAULT NULL,
  `invoice_footer` text DEFAULT NULL,
  `payment_term` int(11) DEFAULT 0,
  `logo` varchar(255) DEFAULT 'logo.png',
  `award_points` int(11) DEFAULT 0,
  `deposit_amount` decimal(25,4) DEFAULT NULL,
  `price_group_id` int(11) DEFAULT NULL,
  `price_group_name` varchar(50) DEFAULT NULL,
  `gst_no` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`),
  KEY `group_id_2` (`group_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_companies`
--

LOCK TABLES `sma_companies` WRITE;
/*!40000 ALTER TABLE `sma_companies` DISABLE KEYS */;
INSERT INTO `sma_companies` VALUES (1,3,'customer',1,'General','Walk-in Customer','Walk-in Customer','','Dubai - Satwa','Dubai','Dubai ','46000','UAE','0123456789','Mustafa@mustafa.com','','','','','','',NULL,0,'logo.png',0,NULL,NULL,NULL,''),(2,4,'supplier',NULL,NULL,'Test Supplier','Supplier Company Name',NULL,'Supplier Address','Petaling Jaya','Selangor','46050','Malaysia','0123456789','supplier@tecdiary.com','-','-','-','-','-','-',NULL,0,'logo.png',0,NULL,NULL,NULL,NULL),(3,NULL,'biller',NULL,NULL,'Mustafa','Mustafa Softawares LLC ','0000000','Dubai - Satwa ','Dubai','','','Country','00971505883505','innovaposuae@gmail.com','','','','','','',' Thank you for shopping with us. Please come again',0,'logo1.png',0,NULL,NULL,NULL,''),(4,3,'customer',1,'General','Sam','ssss','','sss','s','','','','0444444444','dinamicorestaurant509@gmail.com','','','','','','',NULL,0,'logo.png',0,NULL,1,'Default','');
/*!40000 ALTER TABLE `sma_companies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_costing`
--

DROP TABLE IF EXISTS `sma_costing`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_costing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `product_id` int(11) DEFAULT NULL,
  `sale_item_id` int(11) NOT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `purchase_item_id` int(11) DEFAULT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `purchase_net_unit_cost` decimal(25,4) DEFAULT NULL,
  `purchase_unit_cost` decimal(25,4) DEFAULT NULL,
  `sale_net_unit_price` decimal(25,4) NOT NULL,
  `sale_unit_price` decimal(25,4) NOT NULL,
  `quantity_balance` decimal(15,4) DEFAULT NULL,
  `inventory` tinyint(1) DEFAULT 0,
  `overselling` tinyint(1) DEFAULT 0,
  `option_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `transfer_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_costing`
--

LOCK TABLES `sma_costing` WRITE;
/*!40000 ALTER TABLE `sma_costing` DISABLE KEYS */;
INSERT INTO `sma_costing` VALUES (1,'2022-04-06',2,1,1,NULL,1.0000,50.0000,52.5000,80.0000,84.0000,-1.0000,1,1,NULL,NULL,NULL),(2,'2022-12-27',1,2,2,NULL,1.0000,250.0000,262.5000,325.0000,341.2500,-1.0000,1,1,NULL,NULL,NULL);
/*!40000 ALTER TABLE `sma_costing` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_currencies`
--

DROP TABLE IF EXISTS `sma_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(5) NOT NULL,
  `name` varchar(55) NOT NULL,
  `rate` decimal(12,4) NOT NULL,
  `auto_update` tinyint(1) NOT NULL DEFAULT 0,
  `symbol` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_currencies`
--

LOCK TABLES `sma_currencies` WRITE;
/*!40000 ALTER TABLE `sma_currencies` DISABLE KEYS */;
INSERT INTO `sma_currencies` VALUES (1,'USD','US Dollar',1.0000,0,NULL),(2,'EUR','EURO',0.7340,0,NULL);
/*!40000 ALTER TABLE `sma_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_customer_groups`
--

DROP TABLE IF EXISTS `sma_customer_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_customer_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `percent` int(11) NOT NULL,
  `discount` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_customer_groups`
--

LOCK TABLES `sma_customer_groups` WRITE;
/*!40000 ALTER TABLE `sma_customer_groups` DISABLE KEYS */;
INSERT INTO `sma_customer_groups` VALUES (1,'General',0,NULL),(2,'Reseller',-5,NULL),(3,'Distributor',-15,NULL),(4,'New Customer (+10)',10,NULL);
/*!40000 ALTER TABLE `sma_customer_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_date_format`
--

DROP TABLE IF EXISTS `sma_date_format`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_date_format` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `js` varchar(20) NOT NULL,
  `php` varchar(20) NOT NULL,
  `sql` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_date_format`
--

LOCK TABLES `sma_date_format` WRITE;
/*!40000 ALTER TABLE `sma_date_format` DISABLE KEYS */;
INSERT INTO `sma_date_format` VALUES (1,'mm-dd-yyyy','m-d-Y','%m-%d-%Y'),(2,'mm/dd/yyyy','m/d/Y','%m/%d/%Y'),(3,'mm.dd.yyyy','m.d.Y','%m.%d.%Y'),(4,'dd-mm-yyyy','d-m-Y','%d-%m-%Y'),(5,'dd/mm/yyyy','d/m/Y','%d/%m/%Y'),(6,'dd.mm.yyyy','d.m.Y','%d.%m.%Y');
/*!40000 ALTER TABLE `sma_date_format` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_deliveries`
--

DROP TABLE IF EXISTS `sma_deliveries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_deliveries` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `sale_id` int(11) NOT NULL,
  `do_reference_no` varchar(50) NOT NULL,
  `sale_reference_no` varchar(50) NOT NULL,
  `customer` varchar(55) NOT NULL,
  `address` varchar(1000) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `status` varchar(15) DEFAULT NULL,
  `attachment` varchar(50) DEFAULT NULL,
  `delivered_by` varchar(50) DEFAULT NULL,
  `received_by` varchar(50) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_deliveries`
--

LOCK TABLES `sma_deliveries` WRITE;
/*!40000 ALTER TABLE `sma_deliveries` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_deliveries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_deposits`
--

DROP TABLE IF EXISTS `sma_deposits`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_deposits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `company_id` int(11) NOT NULL,
  `amount` decimal(25,4) NOT NULL,
  `paid_by` varchar(50) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) NOT NULL,
  `updated_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_deposits`
--

LOCK TABLES `sma_deposits` WRITE;
/*!40000 ALTER TABLE `sma_deposits` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_deposits` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_expense_categories`
--

DROP TABLE IF EXISTS `sma_expense_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_expense_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(55) NOT NULL,
  `name` varchar(55) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_expense_categories`
--

LOCK TABLES `sma_expense_categories` WRITE;
/*!40000 ALTER TABLE `sma_expense_categories` DISABLE KEYS */;
INSERT INTO `sma_expense_categories` VALUES (1,'001','Groccery');
/*!40000 ALTER TABLE `sma_expense_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_expenses`
--

DROP TABLE IF EXISTS `sma_expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_expenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `reference` varchar(50) NOT NULL,
  `amount` decimal(25,4) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `created_by` varchar(55) NOT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  `category_id` int(11) DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_expenses`
--

LOCK TABLES `sma_expenses` WRITE;
/*!40000 ALTER TABLE `sma_expenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_expenses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_gift_card_topups`
--

DROP TABLE IF EXISTS `sma_gift_card_topups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_gift_card_topups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `card_id` int(11) NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  `created_by` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `card_id` (`card_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_gift_card_topups`
--

LOCK TABLES `sma_gift_card_topups` WRITE;
/*!40000 ALTER TABLE `sma_gift_card_topups` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_gift_card_topups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_gift_cards`
--

DROP TABLE IF EXISTS `sma_gift_cards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_gift_cards` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `card_no` varchar(20) NOT NULL,
  `value` decimal(25,4) NOT NULL,
  `customer_id` int(11) DEFAULT NULL,
  `customer` varchar(255) DEFAULT NULL,
  `balance` decimal(25,4) NOT NULL,
  `expiry` date DEFAULT NULL,
  `created_by` varchar(55) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `card_no` (`card_no`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_gift_cards`
--

LOCK TABLES `sma_gift_cards` WRITE;
/*!40000 ALTER TABLE `sma_gift_cards` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_gift_cards` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_groups`
--

DROP TABLE IF EXISTS `sma_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_groups` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `description` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_groups`
--

LOCK TABLES `sma_groups` WRITE;
/*!40000 ALTER TABLE `sma_groups` DISABLE KEYS */;
INSERT INTO `sma_groups` VALUES (1,'owner','Owner'),(2,'admin','Administrator'),(3,'customer','Customer'),(4,'supplier','Supplier'),(5,'sales','Sales Staff'),(6,'cashier','Cashier');
/*!40000 ALTER TABLE `sma_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_login_attempts`
--

DROP TABLE IF EXISTS `sma_login_attempts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_login_attempts` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `ip_address` varbinary(16) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_login_attempts`
--

LOCK TABLES `sma_login_attempts` WRITE;
/*!40000 ALTER TABLE `sma_login_attempts` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_login_attempts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_logs`
--

DROP TABLE IF EXISTS `sma_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `detail` varchar(190) NOT NULL,
  `model` longtext DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_logs`
--

LOCK TABLES `sma_logs` WRITE;
/*!40000 ALTER TABLE `sma_logs` DISABLE KEYS */;
INSERT INTO `sma_logs` VALUES (1,'Product is being deleted by owner (User Id: 1)','{\"model\":{\"id\":\"20\",\"code\":\"74712628\",\"name\":\"fdsgsdf\",\"unit\":\"1\",\"cost\":\"34534.0000\",\"price\":\"235.0000\",\"alert_quantity\":\"0.0000\",\"image\":\"17b78c46ec0ccb2990befdb36dbf9782.jpg\",\"category_id\":\"3\",\"subcategory_id\":null,\"cf1\":\"\",\"cf2\":\"\",\"cf3\":\"\",\"cf4\":\"\",\"cf5\":\"\",\"cf6\":\"\",\"quantity\":\"0.0000\",\"tax_rate\":\"0\",\"track_quantity\":\"1\",\"details\":\"\",\"warehouse\":null,\"barcode_symbology\":\"code128\",\"file\":\"\",\"product_details\":\"\",\"tax_method\":\"1\",\"type\":\"standard\",\"supplier1\":\"0\",\"supplier1price\":null,\"supplier2\":null,\"supplier2price\":null,\"supplier3\":null,\"supplier3price\":null,\"supplier4\":null,\"supplier4price\":null,\"supplier5\":null,\"supplier5price\":null,\"promotion\":null,\"promo_price\":null,\"start_date\":null,\"end_date\":null,\"supplier1_part_no\":\"\",\"supplier2_part_no\":null,\"supplier3_part_no\":null,\"supplier4_part_no\":null,\"supplier5_part_no\":null,\"sale_unit\":\"1\",\"purchase_unit\":\"1\",\"brand\":\"0\",\"slug\":\"fdsgsdf\",\"featured\":null,\"weight\":\"0.0000\",\"hsn_code\":null,\"views\":\"0\",\"hide\":\"0\",\"second_name\":\"\",\"hide_pos\":\"0\"}}','2022-08-26 14:06:21');
/*!40000 ALTER TABLE `sma_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_migrations`
--

DROP TABLE IF EXISTS `sma_migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_migrations` (
  `version` bigint(20) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_migrations`
--

LOCK TABLES `sma_migrations` WRITE;
/*!40000 ALTER TABLE `sma_migrations` DISABLE KEYS */;
INSERT INTO `sma_migrations` VALUES (315);
/*!40000 ALTER TABLE `sma_migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_notifications`
--

DROP TABLE IF EXISTS `sma_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `comment` text NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `from_date` datetime DEFAULT NULL,
  `till_date` datetime DEFAULT NULL,
  `scope` tinyint(1) NOT NULL DEFAULT 3,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_notifications`
--

LOCK TABLES `sma_notifications` WRITE;
/*!40000 ALTER TABLE `sma_notifications` DISABLE KEYS */;
INSERT INTO `sma_notifications` VALUES (1,'<p>Thank you for purchasing Retail POS Software. Please do not to contact us If you find any error/bug, please email to innovaposuae@gmail.com or call Mr Mustafa at +971505883505 with details. You can send us your valued suggestions/feedback too.</p>','2014-08-15 10:00:57','2015-01-01 00:00:00','2029-01-31 01:05:00',3);
/*!40000 ALTER TABLE `sma_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_order_ref`
--

DROP TABLE IF EXISTS `sma_order_ref`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_order_ref` (
  `ref_id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NOT NULL,
  `so` int(11) NOT NULL DEFAULT 1,
  `qu` int(11) NOT NULL DEFAULT 1,
  `po` int(11) NOT NULL DEFAULT 1,
  `to` int(11) NOT NULL DEFAULT 1,
  `pos` int(11) NOT NULL DEFAULT 1,
  `do` int(11) NOT NULL DEFAULT 1,
  `pay` int(11) NOT NULL DEFAULT 1,
  `re` int(11) NOT NULL DEFAULT 1,
  `rep` int(11) NOT NULL DEFAULT 1,
  `ex` int(11) NOT NULL DEFAULT 1,
  `ppay` int(11) NOT NULL DEFAULT 1,
  `qa` int(11) DEFAULT 1,
  PRIMARY KEY (`ref_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_order_ref`
--

LOCK TABLES `sma_order_ref` WRITE;
/*!40000 ALTER TABLE `sma_order_ref` DISABLE KEYS */;
INSERT INTO `sma_order_ref` VALUES (1,'2015-03-01',2,1,1,1,1,1,3,1,1,1,1,1);
/*!40000 ALTER TABLE `sma_order_ref` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_payments`
--

DROP TABLE IF EXISTS `sma_payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_payments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NULL DEFAULT current_timestamp(),
  `sale_id` int(11) DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `reference_no` varchar(50) NOT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `paid_by` varchar(20) NOT NULL,
  `cheque_no` varchar(20) DEFAULT NULL,
  `cc_no` varchar(20) DEFAULT NULL,
  `cc_holder` varchar(25) DEFAULT NULL,
  `cc_month` varchar(2) DEFAULT NULL,
  `cc_year` varchar(4) DEFAULT NULL,
  `cc_type` varchar(20) DEFAULT NULL,
  `amount` decimal(25,4) NOT NULL,
  `currency` varchar(3) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  `type` varchar(20) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `pos_paid` decimal(25,4) DEFAULT 0.0000,
  `pos_balance` decimal(25,4) DEFAULT 0.0000,
  `approval_code` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_payments`
--

LOCK TABLES `sma_payments` WRITE;
/*!40000 ALTER TABLE `sma_payments` DISABLE KEYS */;
INSERT INTO `sma_payments` VALUES (1,'2022-04-06 18:13:00',1,NULL,NULL,'33',NULL,'cash','','','','','','Visa',30.0000,NULL,1,NULL,'received','<p>Adcance </p>',0.0000,0.0000,NULL),(2,'2022-04-06 18:14:00',1,NULL,NULL,'IPAY2022/04/0001',NULL,'Cheque','23423423','','','','','Visa',54.0000,NULL,1,NULL,'received','<p>ADIB - Dubai Branch </p>',0.0000,0.0000,NULL),(3,'2022-12-28 01:37:00',2,NULL,NULL,'IPAY2022/12/0002',NULL,'cash','','','','','','Visa',341.2500,NULL,1,NULL,'received','',0.0000,0.0000,NULL);
/*!40000 ALTER TABLE `sma_payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_paypal`
--

DROP TABLE IF EXISTS `sma_paypal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_paypal` (
  `id` int(11) NOT NULL,
  `active` tinyint(4) NOT NULL,
  `account_email` varchar(255) NOT NULL,
  `paypal_currency` varchar(3) NOT NULL DEFAULT 'USD',
  `fixed_charges` decimal(25,4) NOT NULL DEFAULT 2.0000,
  `extra_charges_my` decimal(25,4) NOT NULL DEFAULT 3.9000,
  `extra_charges_other` decimal(25,4) NOT NULL DEFAULT 4.4000,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_paypal`
--

LOCK TABLES `sma_paypal` WRITE;
/*!40000 ALTER TABLE `sma_paypal` DISABLE KEYS */;
INSERT INTO `sma_paypal` VALUES (1,1,'mypaypal@paypal.com','USD',0.0000,0.0000,0.0000);
/*!40000 ALTER TABLE `sma_paypal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_permissions`
--

DROP TABLE IF EXISTS `sma_permissions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_permissions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `group_id` int(11) NOT NULL,
  `products-index` tinyint(1) DEFAULT 0,
  `products-add` tinyint(1) DEFAULT 0,
  `products-edit` tinyint(1) DEFAULT 0,
  `products-delete` tinyint(1) DEFAULT 0,
  `products-cost` tinyint(1) DEFAULT 0,
  `products-price` tinyint(1) DEFAULT 0,
  `quotes-index` tinyint(1) DEFAULT 0,
  `quotes-add` tinyint(1) DEFAULT 0,
  `quotes-edit` tinyint(1) DEFAULT 0,
  `quotes-pdf` tinyint(1) DEFAULT 0,
  `quotes-email` tinyint(1) DEFAULT 0,
  `quotes-delete` tinyint(1) DEFAULT 0,
  `sales-index` tinyint(1) DEFAULT 0,
  `sales-add` tinyint(1) DEFAULT 0,
  `sales-edit` tinyint(1) DEFAULT 0,
  `sales-pdf` tinyint(1) DEFAULT 0,
  `sales-email` tinyint(1) DEFAULT 0,
  `sales-delete` tinyint(1) DEFAULT 0,
  `purchases-index` tinyint(1) DEFAULT 0,
  `purchases-add` tinyint(1) DEFAULT 0,
  `purchases-edit` tinyint(1) DEFAULT 0,
  `purchases-pdf` tinyint(1) DEFAULT 0,
  `purchases-email` tinyint(1) DEFAULT 0,
  `purchases-delete` tinyint(1) DEFAULT 0,
  `transfers-index` tinyint(1) DEFAULT 0,
  `transfers-add` tinyint(1) DEFAULT 0,
  `transfers-edit` tinyint(1) DEFAULT 0,
  `transfers-pdf` tinyint(1) DEFAULT 0,
  `transfers-email` tinyint(1) DEFAULT 0,
  `transfers-delete` tinyint(1) DEFAULT 0,
  `customers-index` tinyint(1) DEFAULT 0,
  `customers-add` tinyint(1) DEFAULT 0,
  `customers-edit` tinyint(1) DEFAULT 0,
  `customers-delete` tinyint(1) DEFAULT 0,
  `suppliers-index` tinyint(1) DEFAULT 0,
  `suppliers-add` tinyint(1) DEFAULT 0,
  `suppliers-edit` tinyint(1) DEFAULT 0,
  `suppliers-delete` tinyint(1) DEFAULT 0,
  `sales-deliveries` tinyint(1) DEFAULT 0,
  `sales-add_delivery` tinyint(1) DEFAULT 0,
  `sales-edit_delivery` tinyint(1) DEFAULT 0,
  `sales-delete_delivery` tinyint(1) DEFAULT 0,
  `sales-email_delivery` tinyint(1) DEFAULT 0,
  `sales-pdf_delivery` tinyint(1) DEFAULT 0,
  `sales-gift_cards` tinyint(1) DEFAULT 0,
  `sales-add_gift_card` tinyint(1) DEFAULT 0,
  `sales-edit_gift_card` tinyint(1) DEFAULT 0,
  `sales-delete_gift_card` tinyint(1) DEFAULT 0,
  `pos-index` tinyint(1) DEFAULT 0,
  `sales-return_sales` tinyint(1) DEFAULT 0,
  `reports-index` tinyint(1) DEFAULT 0,
  `reports-warehouse_stock` tinyint(1) DEFAULT 0,
  `reports-quantity_alerts` tinyint(1) DEFAULT 0,
  `reports-expiry_alerts` tinyint(1) DEFAULT 0,
  `reports-products` tinyint(1) DEFAULT 0,
  `reports-daily_sales` tinyint(1) DEFAULT 0,
  `reports-monthly_sales` tinyint(1) DEFAULT 0,
  `reports-sales` tinyint(1) DEFAULT 0,
  `reports-payments` tinyint(1) DEFAULT 0,
  `reports-purchases` tinyint(1) DEFAULT 0,
  `reports-profit_loss` tinyint(1) DEFAULT 0,
  `reports-customers` tinyint(1) DEFAULT 0,
  `reports-suppliers` tinyint(1) DEFAULT 0,
  `reports-staff` tinyint(1) DEFAULT 0,
  `reports-register` tinyint(1) DEFAULT 0,
  `sales-payments` tinyint(1) DEFAULT 0,
  `purchases-payments` tinyint(1) DEFAULT 0,
  `purchases-expenses` tinyint(1) DEFAULT 0,
  `products-adjustments` tinyint(1) NOT NULL DEFAULT 0,
  `bulk_actions` tinyint(1) NOT NULL DEFAULT 0,
  `customers-deposits` tinyint(1) NOT NULL DEFAULT 0,
  `customers-delete_deposit` tinyint(1) NOT NULL DEFAULT 0,
  `products-barcode` tinyint(1) NOT NULL DEFAULT 0,
  `purchases-return_purchases` tinyint(1) NOT NULL DEFAULT 0,
  `reports-expenses` tinyint(1) NOT NULL DEFAULT 0,
  `reports-daily_purchases` tinyint(1) DEFAULT 0,
  `reports-monthly_purchases` tinyint(1) DEFAULT 0,
  `products-stock_count` tinyint(1) DEFAULT 0,
  `edit_price` tinyint(1) DEFAULT 0,
  `returns-index` tinyint(1) DEFAULT 0,
  `returns-add` tinyint(1) DEFAULT 0,
  `returns-edit` tinyint(1) DEFAULT 0,
  `returns-delete` tinyint(1) DEFAULT 0,
  `returns-email` tinyint(1) DEFAULT 0,
  `returns-pdf` tinyint(1) DEFAULT 0,
  `reports-tax` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_permissions`
--

LOCK TABLES `sma_permissions` WRITE;
/*!40000 ALTER TABLE `sma_permissions` DISABLE KEYS */;
INSERT INTO `sma_permissions` VALUES (1,5,1,0,0,0,0,0,1,1,1,1,1,0,1,1,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,1,1,1,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0),(2,6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `sma_permissions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_price_groups`
--

DROP TABLE IF EXISTS `sma_price_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_price_groups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_price_groups`
--

LOCK TABLES `sma_price_groups` WRITE;
/*!40000 ALTER TABLE `sma_price_groups` DISABLE KEYS */;
INSERT INTO `sma_price_groups` VALUES (1,'Default');
/*!40000 ALTER TABLE `sma_price_groups` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_printers`
--

DROP TABLE IF EXISTS `sma_printers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_printers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(55) NOT NULL,
  `type` varchar(25) NOT NULL,
  `profile` varchar(25) NOT NULL,
  `char_per_line` tinyint(3) unsigned DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `ip_address` varbinary(45) DEFAULT NULL,
  `port` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_printers`
--

LOCK TABLES `sma_printers` WRITE;
/*!40000 ALTER TABLE `sma_printers` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_printers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_product_photos`
--

DROP TABLE IF EXISTS `sma_product_photos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_product_photos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `photo` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_product_photos`
--

LOCK TABLES `sma_product_photos` WRITE;
/*!40000 ALTER TABLE `sma_product_photos` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_product_photos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_product_prices`
--

DROP TABLE IF EXISTS `sma_product_prices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_product_prices` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `price_group_id` int(11) NOT NULL,
  `price` decimal(25,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `price_group_id` (`price_group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_product_prices`
--

LOCK TABLES `sma_product_prices` WRITE;
/*!40000 ALTER TABLE `sma_product_prices` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_product_prices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_product_variants`
--

DROP TABLE IF EXISTS `sma_product_variants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_product_variants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `name` varchar(55) NOT NULL,
  `cost` decimal(25,4) DEFAULT NULL,
  `price` decimal(25,4) DEFAULT NULL,
  `quantity` decimal(15,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unique_product_id_name` (`product_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_product_variants`
--

LOCK TABLES `sma_product_variants` WRITE;
/*!40000 ALTER TABLE `sma_product_variants` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_product_variants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_products`
--

DROP TABLE IF EXISTS `sma_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `name` varchar(255) NOT NULL,
  `unit` int(11) DEFAULT NULL,
  `cost` decimal(25,4) DEFAULT NULL,
  `price` decimal(25,4) NOT NULL,
  `alert_quantity` decimal(15,4) DEFAULT 20.0000,
  `image` varchar(255) DEFAULT 'no_image.png',
  `category_id` int(11) NOT NULL,
  `subcategory_id` int(11) DEFAULT NULL,
  `cf1` varchar(255) DEFAULT NULL,
  `cf2` varchar(255) DEFAULT NULL,
  `cf3` varchar(255) DEFAULT NULL,
  `cf4` varchar(255) DEFAULT NULL,
  `cf5` varchar(255) DEFAULT NULL,
  `cf6` varchar(255) DEFAULT NULL,
  `quantity` decimal(15,4) DEFAULT 0.0000,
  `tax_rate` int(11) DEFAULT NULL,
  `track_quantity` tinyint(1) DEFAULT 1,
  `details` varchar(1000) DEFAULT NULL,
  `warehouse` int(11) DEFAULT NULL,
  `barcode_symbology` varchar(55) NOT NULL DEFAULT 'code128',
  `file` varchar(100) DEFAULT NULL,
  `product_details` text DEFAULT NULL,
  `tax_method` tinyint(1) DEFAULT 0,
  `type` varchar(55) NOT NULL DEFAULT 'standard',
  `supplier1` int(11) DEFAULT NULL,
  `supplier1price` decimal(25,4) DEFAULT NULL,
  `supplier2` int(11) DEFAULT NULL,
  `supplier2price` decimal(25,4) DEFAULT NULL,
  `supplier3` int(11) DEFAULT NULL,
  `supplier3price` decimal(25,4) DEFAULT NULL,
  `supplier4` int(11) DEFAULT NULL,
  `supplier4price` decimal(25,4) DEFAULT NULL,
  `supplier5` int(11) DEFAULT NULL,
  `supplier5price` decimal(25,4) DEFAULT NULL,
  `promotion` tinyint(1) DEFAULT 0,
  `promo_price` decimal(25,4) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `supplier1_part_no` varchar(50) DEFAULT NULL,
  `supplier2_part_no` varchar(50) DEFAULT NULL,
  `supplier3_part_no` varchar(50) DEFAULT NULL,
  `supplier4_part_no` varchar(50) DEFAULT NULL,
  `supplier5_part_no` varchar(50) DEFAULT NULL,
  `sale_unit` int(11) DEFAULT NULL,
  `purchase_unit` int(11) DEFAULT NULL,
  `brand` int(11) DEFAULT NULL,
  `slug` varchar(55) DEFAULT NULL,
  `featured` tinyint(1) DEFAULT NULL,
  `weight` decimal(10,4) DEFAULT NULL,
  `hsn_code` int(11) DEFAULT NULL,
  `views` int(11) NOT NULL DEFAULT 0,
  `hide` tinyint(1) NOT NULL DEFAULT 0,
  `second_name` varchar(255) DEFAULT NULL,
  `hide_pos` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`),
  KEY `category_id` (`category_id`),
  KEY `id` (`id`),
  KEY `id_2` (`id`),
  KEY `category_id_2` (`category_id`),
  KEY `unit` (`unit`),
  KEY `brand` (`brand`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_products`
--

LOCK TABLES `sma_products` WRITE;
/*!40000 ALTER TABLE `sma_products` DISABLE KEYS */;
INSERT INTO `sma_products` VALUES (1,'619659145002','Flash Drive 64G',1,250.0000,325.0000,5.0000,'no_image.png',1,NULL,'','','','','','',-1.0000,2,1,'',NULL,'ean13',NULL,'',1,'standard',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,0,'flash-drive-64g',NULL,0.0000,NULL,0,0,'',0),(2,'102','Cruzer Blade Flash Drive 64G',1,50.0000,80.0000,5.0000,'no_image.png',1,NULL,'','','','','','',-1.0000,2,1,NULL,NULL,'619659097318',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'cruzer-blade-flash-drive-64g',NULL,NULL,0,0,0,'',0),(3,'103','Cruzer Blade Flash Drive 8G',1,10.0000,35.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659000424',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'cruzer-blade-flash-drive-8g',NULL,NULL,0,0,0,'',0),(4,'104','Cruzer Glide 32G',1,30.0000,60.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659115890',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'cruzer-glide-32g',NULL,NULL,0,0,0,'',0),(5,'105','MicroCard With Adapter 8G',1,10.0000,20.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659067021',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'microcard-with-adapter-8g',NULL,NULL,0,0,0,'',0),(6,'106','SDHC Card 4G',1,13.0000,30.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659026578',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'sdhc-card-4g',NULL,NULL,0,0,0,'',0),(7,'107','MicroCard With Adapter 4G',1,7.0000,20.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659066994',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'microcard-with-adapter-4g',NULL,NULL,0,0,0,'',0),(8,'108','Micro Card 16G',1,9.0000,20.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659052775',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'micro-card-16g',NULL,NULL,0,0,0,'',0),(9,'109','Wireless Stick 16G',1,23.0000,40.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659130428',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'wireless-stick-16g',NULL,NULL,0,0,0,'',0),(10,'110','Cruzer Glide 16G',1,23.0000,35.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659115883',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'cruzer-glide-16g',NULL,NULL,0,0,0,'',0),(11,'111','MicroCard With Adapter 32G',1,33.5000,50.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659066918',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'microcard-with-adapter-32g',NULL,NULL,0,0,0,'',0),(12,'112','DUAL Drive 64G',1,60.0000,90.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659149642',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'dual-drive-64g',NULL,NULL,0,0,0,'',0),(13,'113','iXpand Mini Flash Drive 64G',1,82.0000,135.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659153076',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'ixpand-mini-flash-drive-64g',NULL,NULL,0,0,0,'',0),(14,'114','Daul USB Drive 32G',1,60.0000,85.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659143497',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'daul-usb-drive-32g',NULL,NULL,0,0,0,'',0),(15,'115','MicroCard 64G',1,70.0000,120.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659134068',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'microcard-64g',NULL,NULL,0,0,0,'',0),(16,'116','iXpand Mini Flash Drive 128G',1,121.0000,170.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659153113',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'ixpand-mini-flash-drive-128g',NULL,NULL,0,0,0,'',0),(17,'117','MicroCard With Adapter 16G',1,19.0000,30.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659066888',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'microcard-with-adapter-16g',NULL,NULL,0,0,0,'',0),(18,'118','MicroCard 32G',1,12.5000,30.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659061647',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'microcard-32g',NULL,NULL,0,0,0,'',0),(19,'119','MicroCard 16G',1,22.0000,35.0000,5.0000,'no_image.png',1,NULL,'','','','','','',0.0000,2,1,NULL,NULL,'619659134020',NULL,NULL,1,'standard',NULL,0.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,NULL,NULL,NULL,'',NULL,NULL,NULL,NULL,1,1,NULL,'microcard-16g',NULL,NULL,0,0,0,'',0);
/*!40000 ALTER TABLE `sma_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_purchase_items`
--

DROP TABLE IF EXISTS `sma_purchase_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_purchase_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchase_id` int(11) DEFAULT NULL,
  `transfer_id` int(11) DEFAULT NULL,
  `product_id` int(11) NOT NULL,
  `product_code` varchar(50) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `option_id` int(11) DEFAULT NULL,
  `net_unit_cost` decimal(25,4) NOT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `tax` varchar(20) DEFAULT NULL,
  `discount` varchar(20) DEFAULT NULL,
  `item_discount` decimal(25,4) DEFAULT NULL,
  `expiry` date DEFAULT NULL,
  `subtotal` decimal(25,4) NOT NULL,
  `quantity_balance` decimal(15,4) DEFAULT 0.0000,
  `date` date NOT NULL,
  `status` varchar(50) NOT NULL,
  `unit_cost` decimal(25,4) DEFAULT NULL,
  `real_unit_cost` decimal(25,4) DEFAULT NULL,
  `quantity_received` decimal(15,4) DEFAULT NULL,
  `supplier_part_no` varchar(50) DEFAULT NULL,
  `purchase_item_id` int(11) DEFAULT NULL,
  `product_unit_id` int(11) DEFAULT NULL,
  `product_unit_code` varchar(10) DEFAULT NULL,
  `unit_quantity` decimal(15,4) NOT NULL,
  `gst` varchar(20) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  `base_unit_cost` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `purchase_id` (`purchase_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_purchase_items`
--

LOCK TABLES `sma_purchase_items` WRITE;
/*!40000 ALTER TABLE `sma_purchase_items` DISABLE KEYS */;
INSERT INTO `sma_purchase_items` VALUES (1,NULL,NULL,2,'','',NULL,0.0000,0.0000,1,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,-1.0000,'0000-00-00','received',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL),(2,NULL,NULL,1,'','',NULL,0.0000,0.0000,1,0.0000,NULL,NULL,NULL,NULL,NULL,0.0000,-1.0000,'0000-00-00','received',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0.0000,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `sma_purchase_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_purchases`
--

DROP TABLE IF EXISTS `sma_purchases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_purchases` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reference_no` varchar(55) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `supplier_id` int(11) NOT NULL,
  `supplier` varchar(55) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `note` varchar(1000) NOT NULL,
  `total` decimal(25,4) DEFAULT NULL,
  `product_discount` decimal(25,4) DEFAULT NULL,
  `order_discount_id` varchar(20) DEFAULT NULL,
  `order_discount` decimal(25,4) DEFAULT NULL,
  `total_discount` decimal(25,4) DEFAULT NULL,
  `product_tax` decimal(25,4) DEFAULT NULL,
  `order_tax_id` int(11) DEFAULT NULL,
  `order_tax` decimal(25,4) DEFAULT NULL,
  `total_tax` decimal(25,4) DEFAULT 0.0000,
  `shipping` decimal(25,4) DEFAULT 0.0000,
  `grand_total` decimal(25,4) NOT NULL,
  `paid` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `status` varchar(55) DEFAULT '',
  `payment_status` varchar(20) DEFAULT 'pending',
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  `payment_term` tinyint(4) DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `return_id` int(11) DEFAULT NULL,
  `surcharge` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `return_purchase_ref` varchar(55) DEFAULT NULL,
  `purchase_id` int(11) DEFAULT NULL,
  `return_purchase_total` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_purchases`
--

LOCK TABLES `sma_purchases` WRITE;
/*!40000 ALTER TABLE `sma_purchases` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_purchases` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_quote_items`
--

DROP TABLE IF EXISTS `sma_quote_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_quote_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `quote_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_code` varchar(55) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_type` varchar(20) DEFAULT NULL,
  `option_id` int(11) DEFAULT NULL,
  `net_unit_price` decimal(25,4) NOT NULL,
  `unit_price` decimal(25,4) DEFAULT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `tax` varchar(55) DEFAULT NULL,
  `discount` varchar(55) DEFAULT NULL,
  `item_discount` decimal(25,4) DEFAULT NULL,
  `subtotal` decimal(25,4) NOT NULL,
  `serial_no` varchar(255) DEFAULT NULL,
  `real_unit_price` decimal(25,4) DEFAULT NULL,
  `product_unit_id` int(11) DEFAULT NULL,
  `product_unit_code` varchar(10) DEFAULT NULL,
  `unit_quantity` decimal(15,4) NOT NULL,
  `gst` varchar(20) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `quote_id` (`quote_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_quote_items`
--

LOCK TABLES `sma_quote_items` WRITE;
/*!40000 ALTER TABLE `sma_quote_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_quote_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_quotes`
--

DROP TABLE IF EXISTS `sma_quotes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_quotes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `reference_no` varchar(55) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `customer` varchar(55) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `biller_id` int(11) NOT NULL,
  `biller` varchar(55) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `internal_note` varchar(1000) DEFAULT NULL,
  `total` decimal(25,4) NOT NULL,
  `product_discount` decimal(25,4) DEFAULT 0.0000,
  `order_discount` decimal(25,4) DEFAULT NULL,
  `order_discount_id` varchar(20) DEFAULT NULL,
  `total_discount` decimal(25,4) DEFAULT 0.0000,
  `product_tax` decimal(25,4) DEFAULT 0.0000,
  `order_tax_id` int(11) DEFAULT NULL,
  `order_tax` decimal(25,4) DEFAULT NULL,
  `total_tax` decimal(25,4) DEFAULT NULL,
  `shipping` decimal(25,4) DEFAULT 0.0000,
  `grand_total` decimal(25,4) NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `attachment` varchar(55) DEFAULT NULL,
  `supplier_id` int(11) DEFAULT NULL,
  `supplier` varchar(55) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_quotes`
--

LOCK TABLES `sma_quotes` WRITE;
/*!40000 ALTER TABLE `sma_quotes` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_quotes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_return_items`
--

DROP TABLE IF EXISTS `sma_return_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_return_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `return_id` int(11) unsigned NOT NULL,
  `product_id` int(11) unsigned NOT NULL,
  `product_code` varchar(55) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_type` varchar(20) DEFAULT NULL,
  `option_id` int(11) DEFAULT NULL,
  `net_unit_price` decimal(25,4) NOT NULL,
  `unit_price` decimal(25,4) DEFAULT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `tax` varchar(55) DEFAULT NULL,
  `discount` varchar(55) DEFAULT NULL,
  `item_discount` decimal(25,4) DEFAULT NULL,
  `subtotal` decimal(25,4) NOT NULL,
  `serial_no` varchar(255) DEFAULT NULL,
  `real_unit_price` decimal(25,4) DEFAULT NULL,
  `product_unit_id` int(11) DEFAULT NULL,
  `product_unit_code` varchar(10) DEFAULT NULL,
  `unit_quantity` decimal(15,4) NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `gst` varchar(20) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `return_id` (`return_id`),
  KEY `product_id` (`product_id`),
  KEY `product_id_2` (`product_id`,`return_id`),
  KEY `return_id_2` (`return_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_return_items`
--

LOCK TABLES `sma_return_items` WRITE;
/*!40000 ALTER TABLE `sma_return_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_return_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_returns`
--

DROP TABLE IF EXISTS `sma_returns`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_returns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `reference_no` varchar(55) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `customer` varchar(55) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `biller` varchar(55) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `staff_note` varchar(1000) DEFAULT NULL,
  `total` decimal(25,4) NOT NULL,
  `product_discount` decimal(25,4) DEFAULT 0.0000,
  `order_discount_id` varchar(20) DEFAULT NULL,
  `total_discount` decimal(25,4) DEFAULT 0.0000,
  `order_discount` decimal(25,4) DEFAULT 0.0000,
  `product_tax` decimal(25,4) DEFAULT 0.0000,
  `order_tax_id` int(11) DEFAULT NULL,
  `order_tax` decimal(25,4) DEFAULT 0.0000,
  `total_tax` decimal(25,4) DEFAULT 0.0000,
  `grand_total` decimal(25,4) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `total_items` smallint(6) DEFAULT NULL,
  `paid` decimal(25,4) DEFAULT 0.0000,
  `surcharge` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `attachment` varchar(55) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  `shipping` decimal(25,4) DEFAULT 0.0000,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_returns`
--

LOCK TABLES `sma_returns` WRITE;
/*!40000 ALTER TABLE `sma_returns` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_returns` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_sale_items`
--

DROP TABLE IF EXISTS `sma_sale_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_sale_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sale_id` int(11) unsigned NOT NULL,
  `product_id` int(11) unsigned NOT NULL,
  `product_code` varchar(55) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_type` varchar(20) DEFAULT NULL,
  `option_id` int(11) DEFAULT NULL,
  `net_unit_price` decimal(25,4) NOT NULL,
  `unit_price` decimal(25,4) DEFAULT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `tax` varchar(55) DEFAULT NULL,
  `discount` varchar(55) DEFAULT NULL,
  `item_discount` decimal(25,4) DEFAULT NULL,
  `subtotal` decimal(25,4) NOT NULL,
  `serial_no` varchar(255) DEFAULT NULL,
  `real_unit_price` decimal(25,4) DEFAULT NULL,
  `sale_item_id` int(11) DEFAULT NULL,
  `product_unit_id` int(11) DEFAULT NULL,
  `product_unit_code` varchar(10) DEFAULT NULL,
  `unit_quantity` decimal(15,4) NOT NULL,
  `comment` varchar(255) DEFAULT NULL,
  `gst` varchar(20) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `sale_id` (`sale_id`),
  KEY `product_id` (`product_id`),
  KEY `product_id_2` (`product_id`,`sale_id`),
  KEY `sale_id_2` (`sale_id`,`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_sale_items`
--

LOCK TABLES `sma_sale_items` WRITE;
/*!40000 ALTER TABLE `sma_sale_items` DISABLE KEYS */;
INSERT INTO `sma_sale_items` VALUES (1,1,2,'102','Cruzer Blade Flash Drive 64G','standard',NULL,80.0000,84.0000,1.0000,1,4.0000,2,'5%','0',0.0000,84.0000,'',80.0000,NULL,1,'U1',1.0000,NULL,NULL,NULL,NULL,NULL),(2,2,1,'619659145002','Flash Drive 64G','standard',NULL,325.0000,341.2500,1.0000,1,16.2500,2,'5%','0',0.0000,341.2500,'',325.0000,NULL,1,'U1',1.0000,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `sma_sale_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_sales`
--

DROP TABLE IF EXISTS `sma_sales`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_sales` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `reference_no` varchar(55) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `customer` varchar(55) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `biller` varchar(55) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `staff_note` varchar(1000) DEFAULT NULL,
  `total` decimal(25,4) NOT NULL,
  `product_discount` decimal(25,4) DEFAULT 0.0000,
  `order_discount_id` varchar(20) DEFAULT NULL,
  `total_discount` decimal(25,4) DEFAULT 0.0000,
  `order_discount` decimal(25,4) DEFAULT 0.0000,
  `product_tax` decimal(25,4) DEFAULT 0.0000,
  `order_tax_id` int(11) DEFAULT NULL,
  `order_tax` decimal(25,4) DEFAULT 0.0000,
  `total_tax` decimal(25,4) DEFAULT 0.0000,
  `shipping` decimal(25,4) DEFAULT 0.0000,
  `grand_total` decimal(25,4) NOT NULL,
  `sale_status` varchar(20) DEFAULT NULL,
  `payment_status` varchar(20) DEFAULT NULL,
  `payment_term` tinyint(4) DEFAULT NULL,
  `due_date` date DEFAULT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `total_items` smallint(6) DEFAULT NULL,
  `pos` tinyint(1) NOT NULL DEFAULT 0,
  `paid` decimal(25,4) DEFAULT 0.0000,
  `return_id` int(11) DEFAULT NULL,
  `surcharge` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `attachment` varchar(55) DEFAULT NULL,
  `return_sale_ref` varchar(55) DEFAULT NULL,
  `sale_id` int(11) DEFAULT NULL,
  `return_sale_total` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `rounding` decimal(10,4) DEFAULT NULL,
  `suspend_note` varchar(255) DEFAULT NULL,
  `api` tinyint(1) DEFAULT 0,
  `shop` tinyint(1) DEFAULT 0,
  `address_id` int(11) DEFAULT NULL,
  `reserve_id` int(11) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `manual_payment` varchar(55) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  `payment_method` varchar(55) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_sales`
--

LOCK TABLES `sma_sales` WRITE;
/*!40000 ALTER TABLE `sma_sales` DISABLE KEYS */;
INSERT INTO `sma_sales` VALUES (1,'2022-04-06 18:09:00','ree',1,'Walk-in Customer',3,'Mustafa Softawares LLC ',1,'&lt;p&gt;The above items are delivered onGood Conditions&nbsp;&lt;&sol;p&gt;&lt;p&gt;O&lt;&sol;p&gt;','',80.0000,0.0000,'',0.0000,0.0000,4.0000,NULL,0.0000,4.0000,0.0000,84.0000,'completed','paid',0,NULL,1,NULL,NULL,1,0,84.0000,NULL,0.0000,'0',NULL,NULL,0.0000,NULL,NULL,0,0,NULL,NULL,'85b13c94bd4a6582a63b3f81dda89706506b11ffd542c3399076937d1c66a2d1',NULL,NULL,NULL,NULL,NULL),(2,'2022-12-28 01:36:00','SALE2022/12/0001',1,'Walk-in Customer',3,'Mustafa Softawares LLC ',1,'','',325.0000,0.0000,'',0.0000,0.0000,16.2500,NULL,0.0000,16.2500,0.0000,341.2500,'completed','paid',0,NULL,1,NULL,NULL,1,0,341.2500,NULL,0.0000,'0',NULL,NULL,0.0000,NULL,NULL,0,0,NULL,NULL,'ee62e44337a8a730d21b99dc17ec5f247602f3dbb0c66396671fb7f9bdf3cd59',NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `sma_sales` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_sessions`
--

DROP TABLE IF EXISTS `sma_sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_sessions`
--

LOCK TABLES `sma_sessions` WRITE;
/*!40000 ALTER TABLE `sma_sessions` DISABLE KEYS */;
INSERT INTO `sma_sessions` VALUES ('00b8965184b3b8127a9ba05f693c0bf701c06e64','31.219.155.32',1649765556,'__ci_last_regenerate|i:1649765425;requested_page|s:13:\"admin/welcome\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649764953\";last_ip|s:13:\"31.219.155.32\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('0187237f6bcb407e557a89e49161314ee74503a4','92.99.111.115',1649187156,'__ci_last_regenerate|i:1649187156;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649185471\";last_ip|s:13:\"92.99.111.115\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('01e36c5ac44346bd8ae16a94f253715400e4e30e','2.49.72.35',1650221073,'__ci_last_regenerate|i:1650221039;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649765106\";last_ip|s:13:\"31.219.155.32\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('03109a1d67c53d26f0b506bec22c5ed37da4f84b','67.225.228.46',1663001033,'__ci_last_regenerate|i:1663001033;error|s:76:\"<h4>404 Not Found!</h4><p>The page you are looking for can not be found.</p>\";__ci_vars|a:1:{s:5:\"error\";s:3:\"new\";}'),('04c42dcef3ce9554175a1ed2e92583dc73717c46','103.77.137.228',1672190994,'__ci_last_regenerate|i:1672190790;requested_page|s:22:\"admin/reports/products\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672158684\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('050016d392ff5589b0793315c905384146a63821','94.203.113.204',1657106657,'__ci_last_regenerate|i:1657106657;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1652118462\";last_ip|s:12:\"86.98.54.254\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";user_csrf|s:20:\"CjAelFInuTZ568Vdr9c7\";'),('06b9f92fc62479b8dc6301fc6fc38ffd60d31273','217.164.99.55',1673031483,'__ci_last_regenerate|i:1673031483;requested_page|s:5:\"admin\";'),('0787de9aa2e50a889504338db6526507b7af3f4c','185.212.171.246',1672149004,'__ci_last_regenerate|i:1672149004;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('096ccd9a3701391f05e54157936a91c6188b40ae','92.99.111.115',1649186463,'__ci_last_regenerate|i:1649186463;requested_page|s:5:\"admin\";'),('0b50a75d0b7ee4059d642d35d22533c7d650b0e4','2.49.72.35',1649236311,'__ci_last_regenerate|i:1649236311;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:5:\"error\";s:3:\"old\";}'),('0b61471eb0b16b5f6f8c389a4a32d082abcf54ef','86.99.240.219',1650625147,'__ci_last_regenerate|i:1650625146;requested_page|s:19:\"admin/transfers/add\";'),('0cf81fb5acf937b467ac6ebca4a5d88d7dbf5ee4','37.245.176.195',1662479158,'__ci_last_regenerate|i:1662479158;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1661522399\";last_ip|s:13:\"31.215.195.79\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('0eb9a137eb2fd1f1dc11d78c06bfb37908f9c73a','103.77.137.228',1672147770,'__ci_last_regenerate|i:1672147770;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('0fa44061669586ab8b9170f96df0bd5a41a58855','217.164.99.55',1673033659,'__ci_last_regenerate|i:1673033659;requested_page|s:5:\"admin\";'),('1248b1ef1591e988f13ed6263aed4061f58f3c59','217.164.99.55',1673043358,'__ci_last_regenerate|i:1673043279;'),('1252c92688fb0f3d74562cd4dac6eef9a92a2324','2.51.150.232',1654180540,'__ci_last_regenerate|i:1654180540;'),('13bf1ff2ce2337652863b96b18eb26951dd1b61d','5.192.194.15',1668277061,'__ci_last_regenerate|i:1668277061;'),('15512a7ce072d21f1c1bffb25c82aa17c401a8fa','103.77.137.228',1672148660,'__ci_last_regenerate|i:1672148660;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('1640457bfb98cba5042249c4baf99beac761e375','31.219.150.103',1673090651,'__ci_last_regenerate|i:1673090651;'),('166272db415e3562df898de0e8314ef5817b1757','2.49.72.35',1649241546,'__ci_last_regenerate|i:1649241546;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('171e420b73cc2a1dd3994ca47021e0938fb8039e','103.77.137.58',1672125065,'__ci_last_regenerate|i:1672125065;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672070117\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('198a88abe7e156b0ef43219f34ef85f44e5dc6bb','2.49.72.35',1649784203,'__ci_last_regenerate|i:1649784203;'),('1a2c8ee668c48b30dd7022475298b4731f7815b3','72.52.131.20',1673089213,'__ci_last_regenerate|i:1673089213;'),('1aeddd63366633c5925f9a088e6ad573c8406ed8','103.77.137.58',1672119265,'__ci_last_regenerate|i:1672119265;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672070117\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('1bb4a3c0f7cf0261c6a0cfed32a4beda250a7d1c','2.51.36.136',1663062260,'__ci_last_regenerate|i:1663062217;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1663002080\";last_ip|s:11:\"2.49.104.72\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('1eb3ab307bfd74edb0a9f8a4edafefc29ebe0b2c','2.49.72.35',1649233376,'__ci_last_regenerate|i:1649233376;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('2216350dac6cc329febd46ee3f21d9c94ca5e3f6','217.164.99.55',1672855207,'__ci_last_regenerate|i:1672855207;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672223701\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('23f055caebd0dcc5537e9bec497f9c41b2e87d62','217.164.99.55',1672858348,'__ci_last_regenerate|i:1672858345;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672223701\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('24a53aba0a7ad24bb6768447b18083ea59d7be4e','92.99.115.181',1672070459,'__ci_last_regenerate|i:1672070459;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1671055274\";last_ip|s:9:\"2.50.3.75\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('26d376fa36e5ef55b1efd52e0d081e98b150d5a6','92.99.111.115',1649240899,'__ci_last_regenerate|i:1649240899;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649231694\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('2744d384b9f258963b07008c840f9ed6789b2c73','103.77.137.228',1672141891,'__ci_last_regenerate|i:1672141891;requested_page|s:26:\"admin/reports/products_new\";'),('287401d0a10e49e8ef6baaeeb39ab062f1ca9989','46.165.250.72',1672205572,'__ci_last_regenerate|i:1672205567;requested_page|s:26:\"admin/reports/products_new\";'),('29c450f5934947baf9a2470d5838bb849840f1fa','139.28.219.146',1672070170,'__ci_last_regenerate|i:1672070170;requested_page|s:5:\"admin\";'),('2ad997d29a39869e5af6c395693a9bba603ec91c','2.49.104.72',1663001650,'__ci_last_regenerate|i:1663001650;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1662478433\";last_ip|s:14:\"37.245.176.195\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('2b3ef330baf87ab2e1f4bf8d3aecba05b3ed429a','185.212.171.246',1672147735,'__ci_last_regenerate|i:1672147735;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('2ccc7f394576811c2a548d5e11384056fb0d7c23','94.203.113.204',1657106680,'__ci_last_regenerate|i:1657106657;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1652118462\";last_ip|s:12:\"86.98.54.254\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";user_csrf|s:20:\"CjAelFInuTZ568Vdr9c7\";'),('2e98eec2fb5a960aacfd5962e662b0a6eb935933','2.51.151.150',1671176472,'__ci_last_regenerate|i:1671176472;'),('2ee71826c0831a091ffbc7b5f1f8d5b1312c37ef','2.49.65.26',1652344990,'__ci_last_regenerate|i:1652344990;'),('2f902b66d128e2a1a8f8c015327fbe173286fc33','103.77.137.228',1672149039,'__ci_last_regenerate|i:1672149039;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('341932b10d9c2dbf0e1ed63dbc8a5a4429e5fdb1','92.99.111.115',1649186528,'__ci_last_regenerate|i:1649186478;requested_page|s:14:\"admin/products\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649186277\";last_ip|s:13:\"92.99.111.115\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('3507703646ca90e89e904ad7a716ebe68f476385','2.49.72.35',1650273335,'__ci_last_regenerate|i:1650273335;requested_page|s:13:\"admin/welcome\";'),('3656d5ccebb3773f399a39ce774a82d911dbf019','92.99.111.115',1649186460,'__ci_last_regenerate|i:1649186460;'),('38aaaa55f2b3cb2b14cab4ba4437df4e33cb2053','2.49.72.35',1649240326,'__ci_last_regenerate|i:1649240326;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('3a769ccdeb8109c0349dc8ccd3bc410e09fcb5a1','86.99.37.141',1661330216,'__ci_last_regenerate|i:1661330216;'),('3bae486ec715b6414b3f7502639587027da0b242','2.49.104.72',1663001133,'__ci_last_regenerate|i:1663001133;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1662478433\";last_ip|s:14:\"37.245.176.195\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('4075c5a87ade56396fad924212f633c7bc6be3d1','2.49.72.35',1649233684,'__ci_last_regenerate|i:1649233684;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:5:\"error\";s:3:\"old\";}'),('43a3f4dc39ec1a7b33c172b7f55a8a489fc32e7f','217.164.99.55',1672852730,'__ci_last_regenerate|i:1672852730;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672223701\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('4480d378d7727b42f6a3c4918c2894b0b4fa09ef','103.77.137.228',1672190427,'__ci_last_regenerate|i:1672190427;requested_page|s:26:\"admin/reports/products_new\";'),('45ac2ccadcee8d29a6030edaf54c5e2e3594a795','2.49.72.35',1649236639,'__ci_last_regenerate|i:1649236639;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('46481b5a6ec3bd360cfea35902f3e8dfdb09e3cb','2.49.72.35',1649751481,'__ci_last_regenerate|i:1649751480;requested_page|s:13:\"admin/welcome\";'),('475f72f45de3d4cbf98e47be2170b744924f0e72','92.99.111.115',1649201412,'__ci_last_regenerate|i:1649201412;requested_page|s:5:\"admin\";'),('49b628d586d9610298d64acb7feb01ce456f85a8','2.51.158.80',1654265685,'__ci_last_regenerate|i:1654265685;'),('4ba404fb3918510a92e60826e0e1ee998aa2d33a','185.212.171.246',1672148080,'__ci_last_regenerate|i:1672148080;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('4db0028d39e70a2b6c7cbfef15b45e82b77b1927','72.52.131.20',1673094488,'__ci_last_regenerate|i:1673094488;'),('4eddfe9e737edb04cbf770f62714dfa17d7a5170','2.49.72.35',1649188601,'__ci_last_regenerate|i:1649188601;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187583\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('50c1c0e4c9554a70bd5789aaf568dccf8f53bfa2','2.51.133.94',1651004111,'__ci_last_regenerate|i:1651004111;'),('520c9401638092ad3dc5b4e6a2da6ba6146b3d39','2.49.72.35',1649187697,'__ci_last_regenerate|i:1649187552;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649186633\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('52f0bec90a9523fca02d0a177a032d2473998d99','2.51.132.248',1666083547,'__ci_last_regenerate|i:1666083540;requested_page|s:15:\"admin/purchases\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1663062226\";last_ip|s:11:\"2.51.36.136\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('55b1a13f27623431fa7c30f66983431fac882402','92.99.115.181',1672073809,'__ci_last_regenerate|i:1672073809;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1671055274\";last_ip|s:9:\"2.50.3.75\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('566957a21cdc59b559165d6e7777af61b086a43b','2.49.72.35',1649186959,'__ci_last_regenerate|i:1649186959;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649186557\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('5751f32ff13dc2ebe9cda58d4fcd89e94afa32aa','103.77.137.228',1672149643,'__ci_last_regenerate|i:1672149643;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('5a92601695e4c1d7b76b4e3e658c098a3451fc34','86.98.51.245',1657642950,'__ci_last_regenerate|i:1657642950;'),('5b33b0609dce4a0f2d9050dc51ef7b42ba447fda','92.99.115.181',1672159894,'__ci_last_regenerate|i:1672159894;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672150384\";last_ip|s:10:\"5.38.36.68\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('5d613d22c157a48e514104753ddce6c1e8b86920','5.30.32.133',1649764940,'__ci_last_regenerate|i:1649764940;'),('5db2e436bd6eecba7a263a16ea62471a68de105d','5.192.186.158',1657642950,'__ci_last_regenerate|i:1657642950;'),('5db56d80c16b7eae36a57b9265315bceb3a0eff4','103.155.234.163',1672150654,'__ci_last_regenerate|i:1672150654;requested_page|s:26:\"admin/reports/products_new\";'),('5dbfb98158ec061d591fdeffb87a97176d4833f0','103.77.137.228',1672140287,'__ci_last_regenerate|i:1672140287;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('5fd0615edc6b9b6f830a596d06132a12b525cde3','86.98.54.254',1652118463,'__ci_last_regenerate|i:1652118459;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1652036806\";last_ip|s:12:\"94.59.120.36\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('61a5cfb9b61809e18af7d24f3444c959233dce90','2.51.154.155',1672053233,'__ci_last_regenerate|i:1672053233;'),('61db2322af404b889957e542c0f4a4c7ccb04e60','103.77.137.228',1672145115,'__ci_last_regenerate|i:1672145115;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('624eafb74cb1d9beeb92d7af1d027c524b83d696','31.215.195.79',1661522790,'__ci_last_regenerate|i:1661522790;'),('6596761826aac34190d3f96c9a859d62591f5b6b','92.99.111.115',1649186740,'__ci_last_regenerate|i:1649186740;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649185471\";last_ip|s:13:\"92.99.111.115\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('65b23aab704ab41f58f2e47de8992a4c9e0f21aa','67.225.228.46',1663001033,'__ci_last_regenerate|i:1663001033;'),('6727684060f968e46db4ca5986219aa495a2e5cb','2.49.72.35',1649236998,'__ci_last_regenerate|i:1649236998;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('67dd9b45e7210ff7f27901d2724daee3c8e414bc','92.99.111.115',1649189623,'__ci_last_regenerate|i:1649189623;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649185471\";last_ip|s:13:\"92.99.111.115\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('67dea2341965032e0556f324d6ac5eb3e0e9a282','103.77.137.228',1672144782,'__ci_last_regenerate|i:1672144782;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('6921ca9894570ab66ec68636d0c4f5d3a9b3dac4','217.164.99.55',1673033660,'__ci_last_regenerate|i:1673033659;requested_page|s:18:\"admin/products/add\";'),('6aee221d201791bc88c56507d04b68842000149b','92.99.115.181',1672159016,'__ci_last_regenerate|i:1672159016;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672150384\";last_ip|s:10:\"5.38.36.68\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('6c96aabef53aded82997e4e6ebc8e1ffbd320da5','217.164.99.55',1673112313,'__ci_last_regenerate|i:1673112313;'),('6ea908d795dd16abeee93a1bbcbac168078e64bd','103.77.137.228',1672141101,'__ci_last_regenerate|i:1672141101;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('6f8f0bc6d8898210d296d0d4e318f850fa3a2ff3','2.49.104.72',1663002080,'__ci_last_regenerate|i:1663002080;'),('7120c9fe24ea5f2fd7eb9fce47a1722e674d814c','2.51.154.155',1672053233,'__ci_last_regenerate|i:1672053233;'),('742b7996d621b43c4048cecba3e357d4cb10cd02','2.49.65.241',1669223161,'__ci_last_regenerate|i:1669223150;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1666083546\";last_ip|s:12:\"2.51.132.248\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('75f45f48c198fa84eb6437f77e5954d54d45a4ac','37.245.176.195',1662479259,'__ci_last_regenerate|i:1662479158;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1661522399\";last_ip|s:13:\"31.215.195.79\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('7675a7865950cc24d106468ddcbc3b00b9fce921','103.77.137.228',1672143504,'__ci_last_regenerate|i:1672143504;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('778e2cc7e0cc9405668fab8f93fdd340d3cf09d5','31.215.195.79',1661522757,'__ci_last_regenerate|i:1661522757;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1657105970\";last_ip|s:14:\"94.203.113.204\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('77fbe6f21d9186e0d3c3f013e4d85df9338d8f87','2.49.72.35',1649239152,'__ci_last_regenerate|i:1649239152;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('7939266676ff49c7fdb60d70fbdcacfdc62ba760','2.49.72.35',1649188250,'__ci_last_regenerate|i:1649188250;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187583\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('7988c7e2eac730ca51332b7e6b181bfdd83e7d6f','94.206.153.88',1662478458,'__ci_last_regenerate|i:1662478458;'),('7c7da07eff80f4e39afa3f164153ac4a3234319f','217.164.99.55',1673029519,'__ci_last_regenerate|i:1673029519;requested_page|s:5:\"admin\";'),('7c803b7d443598080bf162c921297d593c803e91','2.49.72.35',1649187040,'__ci_last_regenerate|i:1649186959;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649186557\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('7d9a49096cc03d98c758eb1afe5277bef31c3241','67.225.228.46',1663001033,'__ci_last_regenerate|i:1663001033;'),('7dd9ad64c2cc96d3f35b173cb25fc63da089f2a1','2.49.72.35',1649188745,'__ci_last_regenerate|i:1649188601;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187583\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('7ddf48f2af9d2844249d4abd696c16eadbd559cb','217.164.99.55',1672224815,'__ci_last_regenerate|i:1672224815;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672190448\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('7f094a5f71d8f83bc561b05c867f951ded15d9a3','92.99.111.115',1649186265,'__ci_last_regenerate|i:1649186265;requested_page|s:5:\"admin\";'),('81768a5c44f1ec63e7c634a994fe96cc369b2a3a','31.219.155.32',1649765041,'__ci_last_regenerate|i:1649764937;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649690958\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('817ae627f972de9083e12c401d06dae35d7b8151','217.164.99.55',1672938725,'__ci_last_regenerate|i:1672938725;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672852375\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('831d1a7f2590300e7ecbc97cae2d46f7911de97f','92.99.115.181',1672136589,'__ci_last_regenerate|i:1672136577;requested_page|s:11:\"admin/sales\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672118098\";last_ip|s:13:\"103.77.137.58\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('86688ff9d2d97b75e8b22e5e9db1e8b396b50464','2.49.72.35',1649187882,'__ci_last_regenerate|i:1649187882;requested_page|s:5:\"admin\";'),('86b3d743875b30f0aa4e7b10385e26ddc88608e9','72.52.131.20',1673094488,'__ci_last_regenerate|i:1673094488;'),('891ba4826b6722741170a9aabc3cfed529547e6e','115.187.44.237',1672670855,'__ci_last_regenerate|i:1672670854;requested_page|s:26:\"admin/reports/products_new\";'),('8c2d676cbeeeb79e3b0bbacf0816d6b3d7778d5a','185.212.171.246',1672149358,'__ci_last_regenerate|i:1672149358;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('8d2b88cda3b2288b2899ffbb8bdad3ab8935a747','92.99.115.181',1672073809,'__ci_last_regenerate|i:1672073809;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1671055274\";last_ip|s:9:\"2.50.3.75\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('8de182d1a7ba570ced556fe9b31193a67b76e2d3','2.49.65.241',1668414921,'__ci_last_regenerate|i:1668414921;'),('8ed64665a0e51c1d2bf888d14f784e1ee7b501a8','31.218.156.51',1649408919,'__ci_last_regenerate|i:1649408918;requested_page|s:33:\"admin/system_settings/user_groups\";'),('8f126a730dc2f52a1313ca7e0200b468c8b3bc05','217.164.99.55',1673037469,'__ci_last_regenerate|i:1673037466;requested_page|s:5:\"admin\";'),('8f47da02b6c43fed14bc42ae571b757003c08e44','92.99.111.115',1649186458,'__ci_last_regenerate|i:1649186458;'),('94bec024e9a056e929bdddb2f938a0525ff398ff','67.225.228.46',1663001033,'__ci_last_regenerate|i:1663001033;requested_page|s:5:\"admin\";'),('969c184e953559cf4df8deab209703db3753a1c6','2.51.133.94',1650873253,'__ci_last_regenerate|i:1650873253;'),('980a61651a07ecf7437b9daf04440245090714e2','103.77.137.58',1672128395,'__ci_last_regenerate|i:1672128395;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672070117\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('98164ee73328d987d2d29e5832ef63f4f751ce6c','2.51.151.150',1671098932,'__ci_last_regenerate|i:1671098932;requested_page|s:13:\"admin/welcome\";'),('9a85471f6cce187395b66dae9fb9879b3681ca31','217.164.99.55',1672224226,'__ci_last_regenerate|i:1672224226;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672190448\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('9ae02ac9b86ebe676e63e97546df95bc7573f252','2.49.72.35',1650489095,'__ci_last_regenerate|i:1650489089;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1650221073\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('9e6903ce77cfb3d88ff595f8926b82fec8c35e34','185.212.171.246',1672148664,'__ci_last_regenerate|i:1672148664;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('9ea819785aeb7ebd564d83de417aaf252415324e','103.77.137.228',1672141862,'__ci_last_regenerate|i:1672141862;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('9fe4fac2c30221bb3ce56fee96ec932fcd3824fe','103.77.137.58',1672139516,'__ci_last_regenerate|i:1672139516;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672070117\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('a07e5bd2cc6754273295f47bc298b024a5aee614','5.38.36.68',1672156076,'__ci_last_regenerate|i:1672156076;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672147007\";last_ip|s:15:\"185.212.171.246\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('a15897aa0903de8aaa35f2db620a8aea53a77efa','103.77.137.228',1672150271,'__ci_last_regenerate|i:1672149980;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('a525ea542e2864702e764fcddeda7bc43b48da52','2.50.3.75',1671055286,'__ci_last_regenerate|i:1671055255;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1669223160\";last_ip|s:11:\"2.49.65.241\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('a5a80bbcb32fe0845137bdb801173e5e82a9b52e','2.51.132.248',1666098213,'__ci_last_regenerate|i:1666098213;'),('a656cf44605677a4823078bf812c4e362c707a0f','86.98.51.245',1657628569,'__ci_last_regenerate|i:1657628569;'),('a8e34a49d939d68afdc512bfdd14056deee2247d','31.219.150.103',1673088834,'__ci_last_regenerate|i:1673088663;'),('a9d1b46e711bc77c1eb2da023d9fd3283b25b8d7','31.219.155.32',1649765425,'__ci_last_regenerate|i:1649765425;requested_page|s:13:\"admin/welcome\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649764953\";last_ip|s:13:\"31.219.155.32\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('ab450e60cd6438abe39783b404466fc1771a1f94','2.49.72.35',1649324644,'__ci_last_regenerate|i:1649324644;'),('acbf63c9d69a52e3134299a00681d90230139842','103.77.137.228',1672142225,'__ci_last_regenerate|i:1672142225;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('acd7c8f9b00760e4b0e1e71106d67ada7ffad32f','92.99.111.115',1649189644,'__ci_last_regenerate|i:1649189623;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649185471\";last_ip|s:13:\"92.99.111.115\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('acff21a36a09f9de90444ab03a3315d6e8600bb4','2.49.72.35',1649237353,'__ci_last_regenerate|i:1649237353;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('ad5f7cf5c847c2c29b3ea88215a6244de75fc47f','92.99.111.115',1649187653,'__ci_last_regenerate|i:1649187653;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649185471\";last_ip|s:13:\"92.99.111.115\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('adbdda098004208e0bdf036ba411b93bfe15c56b','2.49.72.35',1649241933,'__ci_last_regenerate|i:1649241933;'),('adf7cd86e69a6ca8b107adf0162bde0ba7e4ab34','103.77.137.228',1672139951,'__ci_last_regenerate|i:1672139951;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('af528be882d28fdb833dfd679310decdfe479453','2.49.72.35',1649241933,'__ci_last_regenerate|i:1649241933;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('af6452877ebe2403cad5b94eae41ead031cd02bc','83.110.3.17',1650537951,'__ci_last_regenerate|i:1650537688;requested_page|s:13:\"admin/welcome\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1650489095\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('b03dcce39007f99e0dbdc192d5f24f40b3d37f1a','67.225.228.46',1663001033,'__ci_last_regenerate|i:1663001033;'),('b0a841d5600c714b8fc616500e0ea65ac31002a8','86.97.177.208',1651676058,'__ci_last_regenerate|i:1651675954;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1650537688\";last_ip|s:11:\"83.110.3.17\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('b10042d041564250d96a8ace97dd1bdaba6c3818','2.49.72.35',1649240634,'__ci_last_regenerate|i:1649240634;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('b25477d58708ee4fc5643efc4fff4e80b0d86c88','217.164.99.55',1673031877,'__ci_last_regenerate|i:1673031877;requested_page|s:5:\"admin\";'),('b44489fedd63eb7c92ad6dfe9f3b392c11c0a0c7','2.50.142.207',1649830548,'__ci_last_regenerate|i:1649830548;requested_page|s:11:\"admin/sales\";'),('b73c5523cebb188db2ba26fb7f64a8c23e3c8f6c','2.49.72.35',1649324644,'__ci_last_regenerate|i:1649324644;'),('b8a8c2165335ceac1a92d18b17bd876fd1109f63','92.99.111.115',1649240980,'__ci_last_regenerate|i:1649240899;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649231694\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('b97f9dbad57c283550fcfa7c91ed9a7c042e9b00','217.164.99.55',1672858345,'__ci_last_regenerate|i:1672858345;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672223701\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('bbcee6560f7fb5bb656cce24b24778d093c2e708','2.49.72.35',1649588036,'__ci_last_regenerate|i:1649588036;'),('c0068b93dc821649f1a12b3fddab1c168e786b93','92.99.111.115',1649201413,'__ci_last_regenerate|i:1649201412;requested_page|s:14:\"admin/products\";'),('c0c6d747d2670bd8a6b1bbf4c8691afb4066bbe4','103.77.137.228',1672146072,'__ci_last_regenerate|i:1672146072;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('c644e8cafafe0626993bf056f4a100dc8ab6d605','2.49.72.35',1650273335,'__ci_last_regenerate|i:1650273335;requested_page|s:13:\"admin/welcome\";'),('c92c131dee6e91353e84b5137310c283d2d22d3a','2.49.65.241',1668181902,'__ci_last_regenerate|i:1668181902;'),('c93a8dafd2c156c9bc695aa2bb0ad1a49821f7c7','35.163.35.194',1654492257,'__ci_last_regenerate|i:1654492256;requested_page|s:5:\"admin\";'),('c9c6793a0f7d29319fa3cb8ee599fcafc72a26f0','72.52.131.20',1673043110,'__ci_last_regenerate|i:1673043110;'),('ca893f3863c9fd7b11bc424510a8b61744eebbc7','92.99.115.181',1672163566,'__ci_last_regenerate|i:1672163566;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672150384\";last_ip|s:10:\"5.38.36.68\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('cba3c2226664503d518b1a2708816a2523391e24','185.212.171.246',1672150906,'__ci_last_regenerate|i:1672150906;'),('cc4c9129a05364a0f9fff04fd51292b5c1ca60e2','37.245.176.195',1662478417,'__ci_last_regenerate|i:1662478417;'),('cd35fd0c6b261972c2e292f87f20792c0e1abfa4','2.49.65.26',1652428038,'__ci_last_regenerate|i:1652428038;'),('cf5a6762e8090b64c704209f6e4346a075784e66','31.219.150.103',1673090651,'__ci_last_regenerate|i:1673090651;'),('d140987712b66a0f62bb1a98e094f7c9f4073905','86.98.49.56',1651657853,'__ci_last_regenerate|i:1651657853;'),('d47dbf76acbb6c6e23ced156ac53ee6c6c94d732','103.77.137.228',1672143150,'__ci_last_regenerate|i:1672143150;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('d4f60905bcf3f8974ce339d2a1be38160e25e84c','31.219.150.103',1673090206,'__ci_last_regenerate|i:1673090206;'),('d5760889aefb8d62b7cd940993144500b8691999','2.49.104.72',1663002085,'__ci_last_regenerate|i:1663002080;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1663000861\";last_ip|s:11:\"2.49.104.72\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('d57e5567e4463b78b421a91202c14ef90d31f2f4','103.77.137.228',1672149980,'__ci_last_regenerate|i:1672149980;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('d64ea9d5edc3c0d9d95424e937a4deff9a0b4646','2.49.65.26',1652174848,'__ci_last_regenerate|i:1652174847;requested_page|s:13:\"admin/welcome\";'),('d997034efad77c506cffb673f0afe2c50e8f9857','217.164.99.55',1672939034,'__ci_last_regenerate|i:1672939034;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672852375\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('dbe8ec4519f6fd5b7f5c7c4b95bdaa4b4ca8ebc6','92.99.115.181',1672163574,'__ci_last_regenerate|i:1672163566;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672150384\";last_ip|s:10:\"5.38.36.68\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('dc1061b16e8ef79bedc10f4e86b966d75b85b9c5','92.99.115.181',1672176245,'__ci_last_regenerate|i:1672176244;requested_page|s:26:\"admin/reports/products_new\";'),('dc362255cd38c42875acebf01757297d9f240047','2.51.35.194',1657650987,'__ci_last_regenerate|i:1657650987;'),('dcbc1ed5a194a6289a0ba3536597fa085d823554','185.212.171.246',1672149825,'__ci_last_regenerate|i:1672149825;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('dd0b87a652e54cc5c4c85051c5e066f714d55df6','5.30.32.133',1651675977,'__ci_last_regenerate|i:1651675973;requested_page|s:5:\"admin\";'),('df24a2d038f3ae8dacf34da7be3e7c541767bf9f','92.99.111.115',1649186460,'__ci_last_regenerate|i:1649186460;requested_page|s:5:\"admin\";'),('e0aa7b145abf2c2bcb63cd5328ae4190192661de','2.49.72.35',1649240015,'__ci_last_regenerate|i:1649240015;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('e104ab1020acee1fb30daa9c4cf5232ee74fe4a9','217.164.99.55',1672224815,'__ci_last_regenerate|i:1672224815;'),('e181b242ced9b19c97fb6a74c8cbe91e4c363739','2.49.65.241',1667379607,'__ci_last_regenerate|i:1667379607;'),('e553c2b9301a334e910110c5228808b320dd102a','185.212.171.246',1672150905,'__ci_last_regenerate|i:1672150905;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('e666002c333b4d961a3b80b995627665f7c9ac86','103.77.137.228',1672148071,'__ci_last_regenerate|i:1672148071;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('e7ee290f19d9406538be0b2446c72b3814aee33f','94.59.120.36',1652036806,'__ci_last_regenerate|i:1652036790;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1651676009\";last_ip|s:13:\"86.97.177.208\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('e8c3b001cc51cdc5196209b2b5a841acf6ceea0f','217.164.99.55',1672939799,'__ci_last_regenerate|i:1672939660;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672852375\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('f04f530ee39571d1193594e6d659654f12c58ba8','103.77.137.228',1672190790,'__ci_last_regenerate|i:1672190790;requested_page|s:22:\"admin/reports/products\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672158684\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('f09c9380f8c992738addbf39723ced4dc5227837','83.110.3.17',1650537688,'__ci_last_regenerate|i:1650537688;requested_page|s:13:\"admin/welcome\";'),('f13e621bee5b2191035ca9b93e23708782a7a779','94.203.113.204',1657106014,'__ci_last_regenerate|i:1657106014;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1652118462\";last_ip|s:12:\"86.98.54.254\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('f22a579bc3ae45ff79cfd59e56ec1575f83471cf','72.52.131.20',1673042249,'__ci_last_regenerate|i:1673042249;requested_page|s:5:\"admin\";'),('f3166fbafa43c023a4de71c4718855789754c25f','217.164.99.55',1672858003,'__ci_last_regenerate|i:1672858003;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672223701\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('f352d0a36eeb4a28b0356ddda143c010b38e9fd7','217.164.99.55',1672856703,'__ci_last_regenerate|i:1672856703;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672223701\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('f3d9ee3efaefbc72c23c6e8848524c9fd1ffc5a4','92.99.111.115',1649186462,'__ci_last_regenerate|i:1649186462;error|s:76:\"<h4>404 Not Found!</h4><p>The page you are looking for can not be found.</p>\";__ci_vars|a:1:{s:5:\"error\";s:3:\"new\";}'),('f4177321bedc374aa03a21aa3a493034c01cfae1','103.77.137.228',1672140696,'__ci_last_regenerate|i:1672140696;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('f443f7747abea245459d4062d7313cac39084f87','35.89.111.155',1659762505,'__ci_last_regenerate|i:1659762504;requested_page|s:5:\"admin\";'),('f4bb28f431b026b6e2705a364353f0a961e49e5b','2.49.72.35',1649239662,'__ci_last_regenerate|i:1649239662;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649187968\";last_ip|s:10:\"2.49.72.35\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('f68481e36fd0e39ea1053577ab95189865f50d67','103.77.137.228',1672139517,'__ci_last_regenerate|i:1672139516;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672070117\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('f7855f5f50ff644d7eccdbdebde5e24ebc113251','2.51.132.248',1666184770,'__ci_last_regenerate|i:1666184769;requested_page|s:5:\"admin\";'),('fad5bb1638f7130d12297193ddad8435d1ec4988','217.164.99.55',1672939660,'__ci_last_regenerate|i:1672939660;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672852375\";last_ip|s:13:\"217.164.99.55\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('fc64e4e6213d2e82767f9f07cde427707ec642b7','104.224.1.106',1673248041,'__ci_last_regenerate|i:1673248041;'),('fd2a4cd37aeec619920904fcd0a60c76f5464ea7','31.215.253.35',1662361364,'__ci_last_regenerate|i:1662361229;requested_page|s:5:\"admin\";error|s:37:\"<p>Login Failed, Please try again</p>\";__ci_vars|a:1:{s:5:\"error\";s:3:\"old\";}'),('fe8a5cb03f135594fbe29bacfb1c5616010dcccf','103.77.137.228',1672141503,'__ci_last_regenerate|i:1672141503;requested_page|s:5:\"admin\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672136589\";last_ip|s:13:\"92.99.115.181\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";hidden1|i:1;'),('fe946b43a6a30247dd666ea0e26e4de01ad5ac5d','94.203.54.163',1672156091,'__ci_last_regenerate|i:1672156076;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672147007\";last_ip|s:15:\"185.212.171.246\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('feea31d911d939cdd6036449b7c58b643bd440a9','185.212.171.246',1672150187,'__ci_last_regenerate|i:1672150187;requested_page|s:26:\"admin/reports/products_new\";identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1672138851\";last_ip|s:14:\"103.77.137.228\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";'),('ff4621a95820bad5f2ef470b63fd12d3f1b38bce','2.49.72.35',1649690958,'__ci_last_regenerate|i:1649690811;identity|s:5:\"owner\";username|s:5:\"owner\";email|s:18:\"owner@tecdiary.com\";user_id|s:1:\"1\";old_last_login|s:10:\"1649240607\";last_ip|s:13:\"92.99.111.115\";avatar|N;gender|s:4:\"male\";group_id|s:1:\"1\";warehouse_id|N;view_right|s:1:\"0\";edit_right|s:1:\"0\";allow_discount|s:1:\"0\";biller_id|N;company_id|N;show_cost|s:1:\"0\";show_price|s:1:\"0\";__ci_vars|a:1:{s:7:\"message\";s:3:\"old\";}'),('ffdaf9a6a6713413378934c6676da8b03115e5d1','103.77.137.228',1672190939,'__ci_last_regenerate|i:1672190938;requested_page|s:22:\"admin/reports/products\";');
/*!40000 ALTER TABLE `sma_sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_settings`
--

DROP TABLE IF EXISTS `sma_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_settings` (
  `setting_id` int(1) NOT NULL,
  `logo` varchar(255) NOT NULL,
  `logo2` varchar(255) NOT NULL,
  `site_name` varchar(55) NOT NULL,
  `language` varchar(20) NOT NULL,
  `default_warehouse` int(2) NOT NULL,
  `accounting_method` tinyint(4) NOT NULL DEFAULT 0,
  `default_currency` varchar(3) NOT NULL,
  `default_tax_rate` int(2) NOT NULL,
  `rows_per_page` int(2) NOT NULL,
  `version` varchar(10) NOT NULL DEFAULT '1.0',
  `default_tax_rate2` int(11) NOT NULL DEFAULT 0,
  `dateformat` int(11) NOT NULL,
  `sales_prefix` varchar(20) DEFAULT NULL,
  `quote_prefix` varchar(20) DEFAULT NULL,
  `purchase_prefix` varchar(20) DEFAULT NULL,
  `transfer_prefix` varchar(20) DEFAULT NULL,
  `delivery_prefix` varchar(20) DEFAULT NULL,
  `payment_prefix` varchar(20) DEFAULT NULL,
  `return_prefix` varchar(20) DEFAULT NULL,
  `returnp_prefix` varchar(20) DEFAULT NULL,
  `expense_prefix` varchar(20) DEFAULT NULL,
  `item_addition` tinyint(1) NOT NULL DEFAULT 0,
  `theme` varchar(20) NOT NULL,
  `product_serial` tinyint(4) NOT NULL,
  `default_discount` int(11) NOT NULL,
  `product_discount` tinyint(1) NOT NULL DEFAULT 0,
  `discount_method` tinyint(4) NOT NULL,
  `tax1` tinyint(4) NOT NULL,
  `tax2` tinyint(4) NOT NULL,
  `overselling` tinyint(1) NOT NULL DEFAULT 0,
  `restrict_user` tinyint(4) NOT NULL DEFAULT 0,
  `restrict_calendar` tinyint(4) NOT NULL DEFAULT 0,
  `timezone` varchar(100) DEFAULT NULL,
  `iwidth` int(11) NOT NULL DEFAULT 0,
  `iheight` int(11) NOT NULL,
  `twidth` int(11) NOT NULL,
  `theight` int(11) NOT NULL,
  `watermark` tinyint(1) DEFAULT NULL,
  `reg_ver` tinyint(1) DEFAULT NULL,
  `allow_reg` tinyint(1) DEFAULT NULL,
  `reg_notification` tinyint(1) DEFAULT NULL,
  `auto_reg` tinyint(1) DEFAULT NULL,
  `protocol` varchar(20) NOT NULL DEFAULT 'mail',
  `mailpath` varchar(55) DEFAULT '/usr/sbin/sendmail',
  `smtp_host` varchar(100) DEFAULT NULL,
  `smtp_user` varchar(100) DEFAULT NULL,
  `smtp_pass` varchar(255) DEFAULT NULL,
  `smtp_port` varchar(10) DEFAULT '25',
  `smtp_crypto` varchar(10) DEFAULT NULL,
  `corn` datetime DEFAULT NULL,
  `customer_group` int(11) NOT NULL,
  `default_email` varchar(100) NOT NULL,
  `mmode` tinyint(1) NOT NULL,
  `bc_fix` tinyint(4) NOT NULL DEFAULT 0,
  `auto_detect_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `captcha` tinyint(1) NOT NULL DEFAULT 1,
  `reference_format` tinyint(1) NOT NULL DEFAULT 1,
  `racks` tinyint(1) DEFAULT 0,
  `attributes` tinyint(1) NOT NULL DEFAULT 0,
  `product_expiry` tinyint(1) NOT NULL DEFAULT 0,
  `decimals` tinyint(2) NOT NULL DEFAULT 2,
  `qty_decimals` tinyint(2) NOT NULL DEFAULT 2,
  `decimals_sep` varchar(2) NOT NULL DEFAULT '.',
  `thousands_sep` varchar(2) NOT NULL DEFAULT ',',
  `invoice_view` tinyint(1) DEFAULT 0,
  `default_biller` int(11) DEFAULT NULL,
  `envato_username` varchar(50) DEFAULT NULL,
  `purchase_code` varchar(100) DEFAULT NULL,
  `rtl` tinyint(1) DEFAULT 0,
  `each_spent` decimal(15,4) DEFAULT NULL,
  `ca_point` tinyint(4) DEFAULT NULL,
  `each_sale` decimal(15,4) DEFAULT NULL,
  `sa_point` tinyint(4) DEFAULT NULL,
  `update` tinyint(1) DEFAULT 0,
  `sac` tinyint(1) DEFAULT 0,
  `display_all_products` tinyint(1) DEFAULT 0,
  `display_symbol` tinyint(1) DEFAULT NULL,
  `symbol` varchar(50) DEFAULT NULL,
  `remove_expired` tinyint(1) DEFAULT 0,
  `barcode_separator` varchar(2) NOT NULL DEFAULT '-',
  `set_focus` tinyint(1) NOT NULL DEFAULT 0,
  `price_group` int(11) DEFAULT NULL,
  `barcode_img` tinyint(1) NOT NULL DEFAULT 1,
  `ppayment_prefix` varchar(20) DEFAULT 'POP',
  `disable_editing` smallint(6) DEFAULT 90,
  `qa_prefix` varchar(55) DEFAULT NULL,
  `update_cost` tinyint(1) DEFAULT NULL,
  `apis` tinyint(1) NOT NULL DEFAULT 0,
  `state` varchar(100) DEFAULT NULL,
  `pdf_lib` varchar(20) DEFAULT 'dompdf',
  `use_code_for_slug` tinyint(1) DEFAULT NULL,
  `ws_barcode_type` varchar(10) DEFAULT 'weight',
  `ws_barcode_chars` tinyint(4) DEFAULT NULL,
  `flag_chars` tinyint(4) DEFAULT NULL,
  `item_code_start` tinyint(4) DEFAULT NULL,
  `item_code_chars` tinyint(4) DEFAULT NULL,
  `price_start` tinyint(4) DEFAULT NULL,
  `price_chars` tinyint(4) DEFAULT NULL,
  `price_divide_by` int(11) DEFAULT NULL,
  `weight_start` tinyint(4) DEFAULT NULL,
  `weight_chars` tinyint(4) DEFAULT NULL,
  `weight_divide_by` int(11) DEFAULT NULL,
  `ksa_qrcode` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`setting_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_settings`
--

LOCK TABLES `sma_settings` WRITE;
/*!40000 ALTER TABLE `sma_settings` DISABLE KEYS */;
INSERT INTO `sma_settings` VALUES (1,'logo2.png','logo3.png','Mustafa Soft','english',1,2,'USD',1,10,'3.4.53',0,5,'SALE','QUOTE','PO','TR','DO','IPAY','SR','PR','',0,'default',1,1,1,1,1,0,1,1,0,'Asia/Dubai',800,800,150,150,0,0,0,0,NULL,'mail','/usr/sbin/sendmail','pop.gmail.com','contact@sma.tecdiary.org','jEFTM4T63AiQ9dsidxhPKt9CIg4HQjCN58n/RW9vmdC/UDXCzRLR469ziZ0jjpFlbOg43LyoSmpJLBkcAHh0Yw==','25',NULL,NULL,1,'innovaposuae@gmail.com',0,4,1,0,2,1,1,0,2,2,'.',',',0,3,'innovaposuae','c5a91688-f72d-490f-8529-ac42a061cd21',0,NULL,NULL,NULL,NULL,0,0,0,0,'',0,'-',0,1,1,'POP',90,'',0,0,'AN','dompdf',0,'weight',0,0,0,0,0,0,0,0,0,0,0);
/*!40000 ALTER TABLE `sma_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_skrill`
--

DROP TABLE IF EXISTS `sma_skrill`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_skrill` (
  `id` int(11) NOT NULL,
  `active` tinyint(4) NOT NULL,
  `account_email` varchar(255) NOT NULL DEFAULT 'testaccount2@moneybookers.com',
  `secret_word` varchar(20) NOT NULL DEFAULT 'mbtest',
  `skrill_currency` varchar(3) NOT NULL DEFAULT 'USD',
  `fixed_charges` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `extra_charges_my` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `extra_charges_other` decimal(25,4) NOT NULL DEFAULT 0.0000,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_skrill`
--

LOCK TABLES `sma_skrill` WRITE;
/*!40000 ALTER TABLE `sma_skrill` DISABLE KEYS */;
INSERT INTO `sma_skrill` VALUES (1,1,'testaccount2@moneybookers.com','mbtest','USD',0.0000,0.0000,0.0000);
/*!40000 ALTER TABLE `sma_skrill` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_stock_count_items`
--

DROP TABLE IF EXISTS `sma_stock_count_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_stock_count_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `stock_count_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_code` varchar(50) DEFAULT NULL,
  `product_name` varchar(255) DEFAULT NULL,
  `product_variant` varchar(55) DEFAULT NULL,
  `product_variant_id` int(11) DEFAULT NULL,
  `expected` decimal(15,4) NOT NULL,
  `counted` decimal(15,4) NOT NULL,
  `cost` decimal(25,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stock_count_id` (`stock_count_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_stock_count_items`
--

LOCK TABLES `sma_stock_count_items` WRITE;
/*!40000 ALTER TABLE `sma_stock_count_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_stock_count_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_stock_counts`
--

DROP TABLE IF EXISTS `sma_stock_counts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_stock_counts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `reference_no` varchar(55) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `type` varchar(10) NOT NULL,
  `initial_file` varchar(50) NOT NULL,
  `final_file` varchar(50) DEFAULT NULL,
  `brands` varchar(50) DEFAULT NULL,
  `brand_names` varchar(100) DEFAULT NULL,
  `categories` varchar(50) DEFAULT NULL,
  `category_names` varchar(100) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `products` int(11) DEFAULT NULL,
  `rows` int(11) DEFAULT NULL,
  `differences` int(11) DEFAULT NULL,
  `matches` int(11) DEFAULT NULL,
  `missing` int(11) DEFAULT NULL,
  `created_by` int(11) NOT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` datetime DEFAULT NULL,
  `finalized` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_stock_counts`
--

LOCK TABLES `sma_stock_counts` WRITE;
/*!40000 ALTER TABLE `sma_stock_counts` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_stock_counts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_tax_rates`
--

DROP TABLE IF EXISTS `sma_tax_rates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_tax_rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  `code` varchar(10) DEFAULT NULL,
  `rate` decimal(12,4) NOT NULL,
  `type` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_tax_rates`
--

LOCK TABLES `sma_tax_rates` WRITE;
/*!40000 ALTER TABLE `sma_tax_rates` DISABLE KEYS */;
INSERT INTO `sma_tax_rates` VALUES (2,'VAT @5%','VAT10',5.0000,'1');
/*!40000 ALTER TABLE `sma_tax_rates` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_transfer_items`
--

DROP TABLE IF EXISTS `sma_transfer_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_transfer_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `product_code` varchar(55) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `option_id` int(11) DEFAULT NULL,
  `expiry` date DEFAULT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `tax` varchar(55) DEFAULT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `net_unit_cost` decimal(25,4) DEFAULT NULL,
  `subtotal` decimal(25,4) DEFAULT NULL,
  `quantity_balance` decimal(15,4) NOT NULL,
  `unit_cost` decimal(25,4) DEFAULT NULL,
  `real_unit_cost` decimal(25,4) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `product_unit_id` int(11) DEFAULT NULL,
  `product_unit_code` varchar(10) DEFAULT NULL,
  `unit_quantity` decimal(15,4) NOT NULL,
  `gst` varchar(20) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `transfer_id` (`transfer_id`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_transfer_items`
--

LOCK TABLES `sma_transfer_items` WRITE;
/*!40000 ALTER TABLE `sma_transfer_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_transfer_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_transfers`
--

DROP TABLE IF EXISTS `sma_transfers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_transfers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transfer_no` varchar(55) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `from_warehouse_id` int(11) NOT NULL,
  `from_warehouse_code` varchar(55) NOT NULL,
  `from_warehouse_name` varchar(55) NOT NULL,
  `to_warehouse_id` int(11) NOT NULL,
  `to_warehouse_code` varchar(55) NOT NULL,
  `to_warehouse_name` varchar(55) NOT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `total` decimal(25,4) DEFAULT NULL,
  `total_tax` decimal(25,4) DEFAULT NULL,
  `grand_total` decimal(25,4) DEFAULT NULL,
  `created_by` varchar(255) DEFAULT NULL,
  `status` varchar(55) NOT NULL DEFAULT 'pending',
  `shipping` decimal(25,4) NOT NULL DEFAULT 0.0000,
  `attachment` varchar(55) DEFAULT NULL,
  `cgst` decimal(25,4) DEFAULT NULL,
  `sgst` decimal(25,4) DEFAULT NULL,
  `igst` decimal(25,4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_transfers`
--

LOCK TABLES `sma_transfers` WRITE;
/*!40000 ALTER TABLE `sma_transfers` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_transfers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_units`
--

DROP TABLE IF EXISTS `sma_units`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_units` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(10) NOT NULL,
  `name` varchar(55) NOT NULL,
  `base_unit` int(11) DEFAULT NULL,
  `operator` varchar(1) DEFAULT NULL,
  `unit_value` varchar(55) DEFAULT NULL,
  `operation_value` varchar(55) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `base_unit` (`base_unit`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_units`
--

LOCK TABLES `sma_units` WRITE;
/*!40000 ALTER TABLE `sma_units` DISABLE KEYS */;
INSERT INTO `sma_units` VALUES (1,'U1','PC',NULL,NULL,NULL,NULL),(2,'Ltr','Ltr',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `sma_units` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_user_logins`
--

DROP TABLE IF EXISTS `sma_user_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_user_logins` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `company_id` int(11) DEFAULT NULL,
  `ip_address` varbinary(16) NOT NULL,
  `login` varchar(100) NOT NULL,
  `time` timestamp NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_user_logins`
--

LOCK TABLES `sma_user_logins` WRITE;
/*!40000 ALTER TABLE `sma_user_logins` DISABLE KEYS */;
INSERT INTO `sma_user_logins` VALUES (1,1,NULL,'92.99.111.115','owner','2022-04-06 03:04:31'),(2,1,NULL,'92.99.111.115','owner','2022-04-06 03:17:57'),(3,1,NULL,'92.99.111.115','owner','2022-04-06 03:22:07'),(4,1,NULL,'2.49.72.35','Owner','2022-04-06 03:22:37'),(5,1,NULL,'2.49.72.35','Owner','2022-04-06 03:23:53'),(6,1,NULL,'2.49.72.35','Owner','2022-04-06 03:39:43'),(7,1,NULL,'2.49.72.35','Owner','2022-04-06 03:46:08'),(8,1,NULL,'2.49.72.35','Owner','2022-04-06 15:54:54'),(9,1,NULL,'92.99.111.115','owner','2022-04-06 18:23:27'),(10,1,NULL,'2.49.72.35','Owner','2022-04-11 23:29:18'),(11,1,NULL,'31.219.155.32','owner','2022-04-12 20:02:33'),(12,1,NULL,'31.219.155.32','owner','2022-04-12 20:05:06'),(13,1,NULL,'2.49.72.35','Owner','2022-04-18 02:44:33'),(14,1,NULL,'2.49.72.35','Owner','2022-04-21 05:11:35'),(15,1,NULL,'83.110.3.17','Owner','2022-04-21 18:41:28'),(16,1,NULL,'86.97.177.208','owner','2022-05-04 22:53:29'),(17,1,NULL,'94.59.120.36','owner','2022-05-09 03:06:46'),(18,1,NULL,'86.98.54.254','Owner','2022-05-10 01:47:42'),(19,1,NULL,'94.203.113.204','owner','2022-07-06 19:12:50'),(20,1,NULL,'31.215.195.79','owner','2022-08-26 21:59:59'),(21,1,NULL,'37.245.176.195','owner','2022-09-06 23:33:53'),(22,1,NULL,'2.49.104.72','owner','2022-09-13 00:41:01'),(23,1,NULL,'2.49.104.72','owner','2022-09-13 01:01:20'),(24,1,NULL,'2.51.36.136','Owner','2022-09-13 17:43:46'),(25,1,NULL,'2.51.132.248','Owner','2022-10-18 16:59:06'),(26,1,NULL,'2.49.65.241','Owner','2022-11-24 02:06:00'),(27,1,NULL,'2.50.3.75','owner','2022-12-15 07:01:14'),(28,1,NULL,'92.99.115.181','owner','2022-12-27 00:55:17'),(29,1,NULL,'103.77.137.58','owner','2022-12-27 14:14:58'),(30,1,NULL,'92.99.115.181','owner','2022-12-27 19:23:09'),(31,1,NULL,'103.77.137.228','owner','2022-12-27 20:00:51'),(32,1,NULL,'185.212.171.246','owner','2022-12-27 22:16:47'),(33,1,NULL,'5.38.36.68','owner','2022-12-27 23:13:04'),(34,1,NULL,'92.99.115.181','owner','2022-12-28 01:31:24'),(35,1,NULL,'103.77.137.228','owner','2022-12-28 10:20:48'),(36,1,NULL,'217.164.99.55','owner','2022-12-28 19:35:01'),(37,1,NULL,'217.164.99.55','owner','2023-01-05 02:12:55'),(38,1,NULL,'217.164.99.55','owner','2023-01-06 02:05:19');
/*!40000 ALTER TABLE `sma_user_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_users`
--

DROP TABLE IF EXISTS `sma_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_users` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `last_ip_address` varbinary(45) DEFAULT NULL,
  `ip_address` varbinary(45) NOT NULL,
  `username` varchar(100) NOT NULL,
  `password` varchar(40) NOT NULL,
  `salt` varchar(40) DEFAULT NULL,
  `email` varchar(100) NOT NULL,
  `activation_code` varchar(40) DEFAULT NULL,
  `forgotten_password_code` varchar(40) DEFAULT NULL,
  `forgotten_password_time` int(11) unsigned DEFAULT NULL,
  `remember_code` varchar(40) DEFAULT NULL,
  `created_on` int(11) unsigned NOT NULL,
  `last_login` int(11) unsigned DEFAULT NULL,
  `active` tinyint(1) unsigned DEFAULT NULL,
  `first_name` varchar(50) DEFAULT NULL,
  `last_name` varchar(50) DEFAULT NULL,
  `company` varchar(100) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `avatar` varchar(55) DEFAULT NULL,
  `gender` varchar(20) DEFAULT NULL,
  `group_id` int(10) unsigned NOT NULL,
  `warehouse_id` int(10) unsigned DEFAULT NULL,
  `biller_id` int(10) unsigned DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `show_cost` tinyint(1) DEFAULT 0,
  `show_price` tinyint(1) DEFAULT 0,
  `award_points` int(11) DEFAULT 0,
  `view_right` tinyint(1) NOT NULL DEFAULT 0,
  `edit_right` tinyint(1) NOT NULL DEFAULT 0,
  `allow_discount` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `group_id` (`group_id`,`warehouse_id`,`biller_id`),
  KEY `group_id_2` (`group_id`,`company_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_users`
--

LOCK TABLES `sma_users` WRITE;
/*!40000 ALTER TABLE `sma_users` DISABLE KEYS */;
INSERT INTO `sma_users` VALUES (1,'217.164.99.55','\0\0','owner','0a1d72bd5733905f5b49ec551c2fedc084c99b25',NULL,'owner@tecdiary.com',NULL,NULL,NULL,'32498a1130a69b6a73848a490268d2a7e0c303c4',1351661704,1672938319,1,'Owner','Owner','MustafaSoft POS ','00971505883505',NULL,'male',1,NULL,NULL,NULL,0,0,0,0,0,0);
/*!40000 ALTER TABLE `sma_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_variants`
--

DROP TABLE IF EXISTS `sma_variants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_variants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_variants`
--

LOCK TABLES `sma_variants` WRITE;
/*!40000 ALTER TABLE `sma_variants` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_variants` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_warehouses`
--

DROP TABLE IF EXISTS `sma_warehouses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_warehouses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(50) NOT NULL,
  `name` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `map` varchar(255) DEFAULT NULL,
  `phone` varchar(55) DEFAULT NULL,
  `email` varchar(55) DEFAULT NULL,
  `price_group_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_warehouses`
--

LOCK TABLES `sma_warehouses` WRITE;
/*!40000 ALTER TABLE `sma_warehouses` DISABLE KEYS */;
INSERT INTO `sma_warehouses` VALUES (1,'WHI','Warehouse 1','<p>Dubai - Satwa</p>',NULL,'012345678','Mustafa@mustafa.com',0),(2,'WHII','Warehouse 2','<p>Dubai Satwa</p>',NULL,'0105292122','MustafaPOS ',0);
/*!40000 ALTER TABLE `sma_warehouses` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_warehouses_products`
--

DROP TABLE IF EXISTS `sma_warehouses_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_warehouses_products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `rack` varchar(55) DEFAULT NULL,
  `avg_cost` decimal(25,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `product_id` (`product_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_warehouses_products`
--

LOCK TABLES `sma_warehouses_products` WRITE;
/*!40000 ALTER TABLE `sma_warehouses_products` DISABLE KEYS */;
INSERT INTO `sma_warehouses_products` VALUES (1,1,1,-1.0000,NULL,250.0000),(2,1,2,0.0000,NULL,250.0000),(3,2,1,-1.0000,NULL,50.0000);
/*!40000 ALTER TABLE `sma_warehouses_products` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sma_warehouses_products_variants`
--

DROP TABLE IF EXISTS `sma_warehouses_products_variants`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sma_warehouses_products_variants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `option_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `warehouse_id` int(11) NOT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `rack` varchar(55) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `option_id` (`option_id`),
  KEY `product_id` (`product_id`),
  KEY `warehouse_id` (`warehouse_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sma_warehouses_products_variants`
--

LOCK TABLES `sma_warehouses_products_variants` WRITE;
/*!40000 ALTER TABLE `sma_warehouses_products_variants` DISABLE KEYS */;
/*!40000 ALTER TABLE `sma_warehouses_products_variants` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2023-01-09  2:11:48
