ALTER TABLE `sma_products` ADD `second_name` VARCHAR(255) NULL;

DROP TABLE IF EXISTS `sma_returns`;
CREATE TABLE IF NOT EXISTS `sma_returns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `reference_no` varchar(55) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `customer` varchar(55) NOT NULL,
  `biller_id` int(11) NOT NULL,
  `biller` varchar(55) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `note` varchar(1000) DEFAULT NULL,
  `staff_note` varchar(1000) DEFAULT NULL,
  `total` decimal(25,4) NOT NULL,
  `product_discount` decimal(25,4) DEFAULT '0.00',
  `order_discount_id` varchar(20) DEFAULT NULL,
  `total_discount` decimal(25,4) DEFAULT '0.00',
  `order_discount` decimal(25,4) DEFAULT '0.00',
  `product_tax` decimal(25,4) DEFAULT '0.00',
  `order_tax_id` int(11) DEFAULT NULL,
  `order_tax` decimal(25,4) DEFAULT '0.00',
  `total_tax` decimal(25,4) DEFAULT '0.00',
  `grand_total` decimal(25,4) NOT NULL,
  `created_by` int(11) DEFAULT NULL,
  `updated_by` int(11) DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `total_items` SMALLINT DEFAULT NULL,
  `paid` decimal(25,4) DEFAULT '0.00',
  `surcharge` decimal(25,4) NOT NULL DEFAULT '0.00',
  `attachment` VARCHAR(55) NULL,
  `hash` VARCHAR(255) NULL,
  `cgst` DECIMAL(25,4) NULL,
  `sgst` DECIMAL(25,4) NULL,
  `igst` DECIMAL(25,4) NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

DROP TABLE IF EXISTS `sma_return_items`;
CREATE TABLE IF NOT EXISTS `sma_return_items` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `return_id` int(11) unsigned NOT NULL,
  `product_id` int(11) unsigned NOT NULL,
  `product_code` varchar(55) NOT NULL,
  `product_name` varchar(255) NOT NULL,
  `product_type` varchar(20) DEFAULT NULL,
  `option_id` int(11) DEFAULT NULL,
  `net_unit_price` decimal(25,4) NOT NULL,
  `unit_price` decimal(25,4) DEFAULT NULL,
  `quantity` decimal(15,4) NOT NULL,
  `warehouse_id` int(11) DEFAULT NULL,
  `item_tax` decimal(25,4) DEFAULT NULL,
  `tax_rate_id` int(11) DEFAULT NULL,
  `tax` varchar(55) DEFAULT NULL,
  `discount` varchar(55) DEFAULT NULL,
  `item_discount` decimal(25,4) DEFAULT NULL,
  `subtotal` decimal(25,4) NOT NULL,
  `serial_no` varchar(255) DEFAULT NULL,
  `real_unit_price` DECIMAL(25,4) NULL,
  `product_unit_id` INT(11) NULL,
  `product_unit_code` VARCHAR(10) NULL,
  `unit_quantity` DECIMAL(15,4) NOT NULL,
  `comment` VARCHAR(255) NULL,
  `gst` VARCHAR(20) NULL,
  `cgst` DECIMAL(25,4) NULL,
  `sgst` DECIMAL(25,4) NULL,
  `igst` DECIMAL(25,4) NULL,
  PRIMARY KEY (`id`),
  KEY `return_id` (`return_id`),
  KEY `product_id` (`product_id`),
  KEY `product_id_2` (`product_id`,`return_id`),
  KEY `return_id_2` (`return_id`,`product_id`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1;

ALTER TABLE `sma_permissions` ADD `returns-index` TINYINT(1) NULL DEFAULT '0',
 ADD `returns-add` TINYINT(1) NULL DEFAULT '0',
 ADD `returns-edit` TINYINT(1) NULL DEFAULT '0',
 ADD `returns-delete` TINYINT(1) NULL DEFAULT '0',
 ADD `returns-email` TINYINT(1) NULL DEFAULT '0',
 ADD `returns-pdf` TINYINT(1) NULL DEFAULT '0',
 ADD `reports-tax` TINYINT(1) NULL DEFAULT '0';

UPDATE `sma_settings` SET `version` = '3.2.12' WHERE `setting_id` = 1;
